/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.io;

import com.tvd12.properties.file.reader.BaseFileReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.exception.FilePermissionException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.util.Strings;

public final class PropertiesFileProxy {
    private PropertiesFileProxy() {
    }

    public static String readToMultiLinesString(File propertiesFile) {
        return String.join((CharSequence)"\n", PropertiesFileProxy.readAndSortToLines(propertiesFile));
    }

    public static List<String> readAndSortToLines(File propertiesFile) {
        return PropertiesFileProxy.readAndSort(propertiesFile).stream().map(Strings::entryToString).collect(Collectors.toList());
    }

    public static List<Map.Entry<String, String>> readAndSort(File propertiesFile) {
        return new BaseFileReader().read(propertiesFile).entrySet().stream().map(it -> it).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
    }

    public static void sortAndWrite(Map<?, ?> properties, File propertiesFile) {
        List commentLines;
        FolderProxy.createNewFile(propertiesFile);
        try {
            commentLines = Files.lines(propertiesFile.toPath()).filter(line -> Strings.startsWithIgnoreSpaces(line, "#")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw FilePermissionException.fromFileAction(propertiesFile, "read");
        }
        ArrayList lines = new ArrayList(commentLines);
        lines.addAll(properties.entrySet().stream().map(Strings::entryToString).sorted().collect(Collectors.toList()));
        try {
            Files.write(propertiesFile.toPath(), lines, new OpenOption[0]);
        }
        catch (IOException e) {
            throw FilePermissionException.fromFileAction(propertiesFile, "write");
        }
    }
}

