/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.model.MediaModel;

public class MediaNameModel {
    private long id;
    private String name;
    private String originalName;
    private MediaType type;
    private String url;

    public static MediaNameModel fromMediaModel(MediaModel model) {
        if (model == null) {
            return null;
        }
        return MediaNameModel.builder().id(model.getId()).name(model.getName()).originalName(model.getOriginalName()).type(model.getType()).url(model.getUrl()).build();
    }

    public static String getMediaNameOrNull(MediaNameModel media) {
        return MediaNameModel.getMediaNameOrDefault(media, null);
    }

    public static String getMediaNameOrDefault(MediaNameModel media, String defaultName) {
        return media == null ? defaultName : media.getName();
    }

    public static String getMediaUrlOrNull(MediaNameModel media) {
        return MediaNameModel.getMediaUrlOrDefault(media, null);
    }

    public static String getMediaUrlOrDefault(MediaNameModel media, String defaultUrl) {
        return media == null ? defaultUrl : media.getUrlOrDefault(defaultUrl);
    }

    @JsonIgnore
    public String getUrlOrNull() {
        return this.getUrlOrDefault(null);
    }

    public String getUrlOrDefault(String defaultUrl) {
        return MediaModel.toMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    public String getMeUrlOrDefault(String defaultUrl) {
        return MediaModel.toMeMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    @Generated
    MediaNameModel(long id, String name, String originalName, MediaType type, String url) {
        this.id = id;
        this.name = name;
        this.originalName = originalName;
        this.type = type;
        this.url = url;
    }

    @Generated
    public static MediaNameModelBuilder builder() {
        return new MediaNameModelBuilder();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @Generated
    public MediaType getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public static class MediaNameModelBuilder {
        @Generated
        private long id;
        @Generated
        private String name;
        @Generated
        private String originalName;
        @Generated
        private MediaType type;
        @Generated
        private String url;

        @Generated
        MediaNameModelBuilder() {
        }

        @Generated
        public MediaNameModelBuilder id(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public MediaNameModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MediaNameModelBuilder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        @Generated
        public MediaNameModelBuilder type(MediaType type) {
            this.type = type;
            return this;
        }

        @Generated
        public MediaNameModelBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public MediaNameModel build() {
            return new MediaNameModel(this.id, this.name, this.originalName, this.type, this.url);
        }

        @Generated
        public String toString() {
            return "MediaNameModel.MediaNameModelBuilder(id=" + this.id + ", name=" + this.name + ", originalName=" + this.originalName + ", type=" + (Object)((Object)this.type) + ", url=" + this.url + ")";
        }
    }
}

