/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.repo;

import com.tvd12.ezydata.jpa.repository.EzyJpaRepository;
import com.tvd12.ezyfox.io.EzyLists;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.youngmonkeys.ezyplatform.entity.DataMeta;
import org.youngmonkeys.ezyplatform.util.Strings;

public class DataMetaTransactionalRepository
extends EzyJpaRepository<Long, DataMeta> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataMetaUniqueKey(String dataType, long dataId, String metaKey, String metaValue, String metaTextValue) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM DataMeta e WHERE e.dataType = ?0 AND e.dataId = ?1 AND e.metaKey = ?2").setParameter(0, (Object)dataType).setParameter(1, (Object)dataId).setParameter(2, (Object)metaKey).setMaxResults(1).getResultList();
                DataMeta entity = (DataMeta)EzyLists.first((List)entities);
                if (entity == null) {
                    entity = new DataMeta();
                    entity.setDataType(dataType);
                    entity.setDataId(dataId);
                    entity.setMetaKey(metaKey);
                }
                entity.setMetaValue(metaValue);
                entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
                entity.setMetaTextValue(metaTextValue);
                entityManager.merge((Object)entity);
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataMetaUniqueKeyValue(String dataType, long dataId, String metaKey, String metaValue) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM DataMeta e WHERE e.dataType = ?0 AND e.dataId = ?1 AND e.metaKey = ?2 AND e.metaValue = ?3").setParameter(0, (Object)dataType).setParameter(1, (Object)dataId).setParameter(2, (Object)metaKey).setParameter(3, (Object)metaValue).setMaxResults(1).getResultList();
                DataMeta entity = (DataMeta)EzyLists.first((List)entities);
                if (entity == null) {
                    entity = new DataMeta();
                    entity.setDataType(dataType);
                    entity.setDataId(dataId);
                    entity.setMetaKey(metaKey);
                    entity.setMetaValue(metaValue);
                    entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
                    entityManager.merge((Object)entity);
                }
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    public BigDecimal increaseMetaValue(String dataType, long dataId, String metaKey, BigDecimal value) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM DataMeta e WHERE e.dataType = ?0 AND e.dataId = ?1 AND e.metaKey = ?2").setParameter(0, (Object)dataType).setParameter(1, (Object)dataId).setParameter(2, (Object)metaKey).setMaxResults(1).getResultList();
                DataMeta entity = (DataMeta)EzyLists.first((List)entities);
                BigDecimal currentValue = BigDecimal.ZERO;
                if (entity == null) {
                    entity = new DataMeta();
                    entity.setDataType(dataType);
                    entity.setDataId(dataId);
                    entity.setMetaKey(metaKey);
                } else {
                    currentValue = new BigDecimal(entity.getMetaValue());
                }
                BigDecimal newValue = currentValue.add(value);
                entity.setMetaValue(newValue.toString());
                entity.setMetaNumberValue(newValue.toBigInteger());
                entityManager.merge((Object)entity);
                transaction.commit();
                BigDecimal bigDecimal = newValue;
                return bigDecimal;
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    protected Class<DataMeta> getEntityType() {
        return DataMeta.class;
    }
}

