/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.repo;

import com.tvd12.ezydata.jpa.repository.EzyJpaRepository;
import com.tvd12.ezyfox.io.EzyLists;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.youngmonkeys.ezyplatform.entity.UserMeta;
import org.youngmonkeys.ezyplatform.util.Strings;

public class UserMetaTransactionalRepository
extends EzyJpaRepository<Long, UserMeta> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserMetaUniqueKey(long userId, String metaKey, String metaValue, String metaTextValue) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM UserMeta e WHERE e.userId = ?0 AND e.metaKey = ?1").setParameter(0, (Object)userId).setParameter(1, (Object)metaKey).setMaxResults(1).getResultList();
                UserMeta entity = (UserMeta)EzyLists.first((List)entities);
                if (entity == null) {
                    entity = new UserMeta();
                    entity.setUserId(userId);
                    entity.setMetaKey(metaKey);
                }
                entity.setMetaValue(metaValue);
                entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
                entity.setMetaTextValue(metaTextValue);
                entityManager.merge((Object)entity);
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserMetaUniqueKeyValue(long userId, String metaKey, String metaValue) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM UserMeta e WHERE e.userId = ?0 AND e.metaKey = ?1 AND e.metaValue = ?2").setParameter(0, (Object)userId).setParameter(1, (Object)metaKey).setParameter(2, (Object)metaValue).setMaxResults(1).getResultList();
                UserMeta entity = (UserMeta)EzyLists.first((List)entities);
                if (entity == null) {
                    entity = new UserMeta();
                    entity.setUserId(userId);
                    entity.setMetaKey(metaKey);
                    entity.setMetaValue(metaValue);
                    entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
                    entityManager.merge((Object)entity);
                }
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    public BigDecimal increaseMetaValue(long userId, String metaKey, BigDecimal value) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM UserMeta e WHERE e.userId = ?0 AND e.metaKey = ?1").setParameter(0, (Object)userId).setParameter(1, (Object)metaKey).setMaxResults(1).getResultList();
                UserMeta entity = (UserMeta)EzyLists.first((List)entities);
                BigDecimal currentValue = BigDecimal.ZERO;
                if (entity == null) {
                    entity = new UserMeta();
                    entity.setUserId(userId);
                    entity.setMetaKey(metaKey);
                } else {
                    currentValue = new BigDecimal(entity.getMetaValue());
                }
                BigDecimal newValue = currentValue.add(value);
                entity.setMetaValue(newValue.toString());
                entity.setMetaNumberValue(newValue.toBigInteger());
                entityManager.merge((Object)entity);
                transaction.commit();
                BigDecimal bigDecimal = newValue;
                return bigDecimal;
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    protected Class<UserMeta> getEntityType() {
        return UserMeta.class;
    }
}

