/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.util.EzyMapCollection;
import java.util.Collection;
import java.util.HashMap;

public abstract class EzyHashMapCollection<K, E, V extends Collection<E>>
extends HashMap<K, V>
implements EzyMapCollection<K, E, V> {
    private static final long serialVersionUID = 3535251482476794711L;

    @Override
    public void addItem(K key, E item) {
        Collection<Object> current = (Collection)this.get(key);
        if (current == null) {
            current = this.newCollection();
            this.put(key, current);
        }
        current.add(item);
    }

    @Override
    public void addItems(K key, Collection<E> items) {
        Collection<Object> current = (Collection)this.get(key);
        if (current == null) {
            current = this.newCollection();
            this.put(key, current);
        }
        current.addAll(items);
    }

    public V getItems(K key) {
        return (V)(this.containsKey(key) ? (Collection)this.get(key) : this.newCollection());
    }

    protected abstract V newCollection();

    @Override
    public void deepClear() {
        for (Collection value : this.values()) {
            value.clear();
        }
        this.clear();
    }
}

