/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.DeserializeBodyException;
import com.tvd12.ezyhttp.core.exception.DeserializeValueException;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.exception.HttpUnauthorizedException;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.ExceptionHandler;
import com.tvd12.ezyhttp.server.core.annotation.TryCatch;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectHasDependingPluginsException;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectInactiveDependenciesException;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectMissingDependenciesException;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectNeedToUpdateDependenciesException;
import org.youngmonkeys.ezyplatform.admin.exception.SuperAdminNotExistedException;
import org.youngmonkeys.ezyplatform.admin.view.AdminViews;
import org.youngmonkeys.ezyplatform.exception.AdminAccessTokenExpiredException;
import org.youngmonkeys.ezyplatform.exception.AdminInvalidAccessTokenException;
import org.youngmonkeys.ezyplatform.exception.BadRequestException;
import org.youngmonkeys.ezyplatform.exception.FilePermissionException;
import org.youngmonkeys.ezyplatform.exception.ForbiddenActionException;
import org.youngmonkeys.ezyplatform.exception.PermissionDeniedException;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.util.HttpRequests;

@ExceptionHandler
public class AdminGlobalExceptionHandler
extends EzyLoggable {
    private final RequestURIManager requestUriManager;

    @TryCatch(value={ProjectMissingDependenciesException.class})
    public Object handle(ProjectMissingDependenciesException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.builder().status(403).body(Collections.singletonMap("projectMissingDependencies", e.getMissingDependencies())).build();
    }

    @TryCatch(value={ProjectNeedToUpdateDependenciesException.class})
    public Object handle(ProjectNeedToUpdateDependenciesException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.builder().status(403).body(Collections.singletonMap("projectNeedToUpdateDependencies", e.getNeedToUpdateDependencies())).build();
    }

    @TryCatch(value={ProjectInactiveDependenciesException.class})
    public Object handle(ProjectInactiveDependenciesException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.builder().status(403).body(Collections.singletonMap("projectInactiveDependencies", e.getInactivePlugins())).build();
    }

    @TryCatch(value={ProjectHasDependingPluginsException.class})
    public Object handle(ProjectHasDependingPluginsException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.builder().status(403).body(Collections.singletonMap("projectDependingPlugins", e.getDependingPlugins())).build();
    }

    @TryCatch(value={SuperAdminNotExistedException.class})
    public Redirect handle(HttpServletRequest request, SuperAdminNotExistedException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/setup-admin"));
    }

    @TryCatch(value={AdminInvalidAccessTokenException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, AdminInvalidAccessTokenException e) {
        this.logger.info("{}({}), ip: {}, requestUri: {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), request.getRemoteHost(), request.getRequestURI()});
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(Collections.singletonMap("token", "invalid")).build();
        }
        return AdminViews.redirectToLogin((HttpServletRequest)request, (boolean)true);
    }

    @TryCatch(value={AdminAccessTokenExpiredException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, AdminAccessTokenExpiredException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(Collections.singletonMap("token", "expired")).build();
        }
        return AdminViews.redirectToLogin((HttpServletRequest)request, (boolean)true);
    }

    @TryCatch(value={BadRequestException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, BadRequestException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.badRequest((Object)e.getErrors());
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
    }

    @TryCatch(value={ResourceNotFoundException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, ResourceNotFoundException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.notFound((Object)e.getResponseData());
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    @TryCatch(value={HttpUnauthorizedException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, HttpUnauthorizedException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(e.getData()).build();
        }
        return AdminViews.redirectToLogin((HttpServletRequest)request, (boolean)true);
    }

    @TryCatch(value={HttpNotFoundException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, HttpNotFoundException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.notFound((Object)e.getData());
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    @TryCatch(value={FilePermissionException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, FilePermissionException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.status((int)403).body(Collections.singletonMap("filePermission", e.getMessage())).build();
        }
        return Redirect.builder().uri(HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/server-error")).addAttribute("exceptionMessage", (Object)EzyStrings.exceptionToSimpleString((Throwable)e)).build();
    }

    @TryCatch(value={ForbiddenActionException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, ForbiddenActionException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.status((int)403).body((Object)e.getResponseData()).build();
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    @TryCatch(value={PermissionDeniedException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, PermissionDeniedException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.status((int)403).body(Collections.singletonMap("permission", "denied")).build();
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/permission-denied"));
    }

    @TryCatch(value={HttpForbiddenException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, HttpForbiddenException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.status((int)403).body(e.getData()).build();
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/permission-denied"));
    }

    @TryCatch(value={DeserializeBodyException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, DeserializeBodyException e) {
        this.logger.info("{}({})", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            HashMap<String, String> errors = new HashMap<String, String>();
            Throwable cause = e.getCause();
            if (cause instanceof InvalidFormatException) {
                InvalidFormatException ex = (InvalidFormatException)cause;
                for (JsonMappingException.Reference ref : ex.getPath()) {
                    errors.put(ref.getFieldName(), "invalid");
                }
            } else {
                errors.put("fields", "invalid");
            }
            return ResponseEntity.badRequest(errors);
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
    }

    @TryCatch(value={DeserializeValueException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, DeserializeValueException e) {
        this.logger.info("{}({})", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.badRequest(Collections.singletonMap(e.getValueName(), "invalid"));
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
    }

    @Generated
    public AdminGlobalExceptionHandler(RequestURIManager requestUriManager) {
        this.requestUriManager = requestUriManager;
    }
}

