/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.data;

import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.EzyFutureTask;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminProjectModel;

public class ProjectInstallation {
    private long adminId;
    private String projectName;
    private String version;
    private String marketAccessToken;
    private boolean uploaded;
    private final EzyFuture future = new EzyFutureTask();
    private static final int DEFAULT_TIMEOUT = 120000;

    public static ProjectInstallation ofUploadFileName(long adminId, String uploadFileName) {
        String fileName = uploadFileName.substring(0, uploadFileName.lastIndexOf(46));
        int lastIndex = fileName.lastIndexOf(45);
        return ProjectInstallation.builder().adminId(adminId).uploaded(true).projectName(fileName.substring(0, lastIndex)).version(fileName.substring(lastIndex + 1)).build();
    }

    public void finish(Exception e) {
        if (e == null) {
            this.future.setResult((Object)Boolean.TRUE);
        } else {
            this.future.setException(e);
        }
    }

    public void await() throws Exception {
        this.future.get(120000L);
    }

    public String getFileName() {
        return this.projectName + "-" + this.version + ".zip";
    }

    public AddAdminProjectModel toAddProjectModel() {
        return AddAdminProjectModel.builder().projectName(this.projectName).version(this.version).adminId(this.adminId).build();
    }

    @Generated
    ProjectInstallation(long adminId, String projectName, String version, String marketAccessToken, boolean uploaded) {
        this.adminId = adminId;
        this.projectName = projectName;
        this.version = version;
        this.marketAccessToken = marketAccessToken;
        this.uploaded = uploaded;
    }

    @Generated
    public static ProjectInstallationBuilder builder() {
        return new ProjectInstallationBuilder();
    }

    @Generated
    public long getAdminId() {
        return this.adminId;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getMarketAccessToken() {
        return this.marketAccessToken;
    }

    @Generated
    public boolean isUploaded() {
        return this.uploaded;
    }

    @Generated
    public static class ProjectInstallationBuilder {
        @Generated
        private long adminId;
        @Generated
        private String projectName;
        @Generated
        private String version;
        @Generated
        private String marketAccessToken;
        @Generated
        private boolean uploaded;

        @Generated
        ProjectInstallationBuilder() {
        }

        @Generated
        public ProjectInstallationBuilder adminId(long adminId) {
            this.adminId = adminId;
            return this;
        }

        @Generated
        public ProjectInstallationBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        @Generated
        public ProjectInstallationBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ProjectInstallationBuilder marketAccessToken(String marketAccessToken) {
            this.marketAccessToken = marketAccessToken;
            return this;
        }

        @Generated
        public ProjectInstallationBuilder uploaded(boolean uploaded) {
            this.uploaded = uploaded;
            return this;
        }

        @Generated
        public ProjectInstallation build() {
            return new ProjectInstallation(this.adminId, this.projectName, this.version, this.marketAccessToken, this.uploaded);
        }

        @Generated
        public String toString() {
            return "ProjectInstallation.ProjectInstallationBuilder(adminId=" + this.adminId + ", projectName=" + this.projectName + ", version=" + this.version + ", marketAccessToken=" + this.marketAccessToken + ", uploaded=" + this.uploaded + ")";
        }
    }
}

