/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyArrayUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.data.PlatformBackup;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformFileManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.data.FileItem;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminBackupManager {
    private final AdminFileSystemManager fileSystemManager;
    private final AdminEzyPlatformFileManager platformFileManager;

    public List<PlatformBackup> getAllBackups() {
        File backupFolder = this.fileSystemManager.getBackupFolder();
        if (!backupFolder.exists()) {
            return Collections.emptyList();
        }
        Object[] backupVersionFolders = backupFolder.listFiles();
        if (EzyArrayUtil.isEmpty((Object[])backupVersionFolders)) {
            return Collections.emptyList();
        }
        ArrayList<PlatformBackup> answer = new ArrayList<PlatformBackup>();
        for (Object backupVersionFolder : backupVersionFolders) {
            List<FileItem> files;
            if (((File)backupVersionFolder).isFile() || (files = this.listBackupFiles((File)backupVersionFolder)).isEmpty()) continue;
            answer.add(PlatformBackup.builder().versionName(((File)backupVersionFolder).getName()).addFiles(files).build());
        }
        Collections.sort(answer);
        return answer;
    }

    public boolean hasRecovery() {
        File recoveryFile = this.fileSystemManager.getNewEzyPlatformRecoverFile();
        return recoveryFile.exists();
    }

    public void recoverBackup(String backupVersion) {
        File backupFolder = Paths.get(this.fileSystemManager.getBackupFolder().toString(), backupVersion).toFile();
        if (!backupFolder.exists()) {
            throw new ResourceNotFoundException("backup");
        }
        this.doRecoverBackup(backupFolder);
    }

    private void doRecoverBackup(File backupFolder) {
        this.platformFileManager.moveFilesToPlatformFolder(backupFolder);
        File recoveryFile = this.fileSystemManager.getNewEzyPlatformRecoverFile();
        FolderProxy.createNewFile((File)recoveryFile);
    }

    public void deleteBackup(String backupVersion) {
        File backupFolder = Paths.get(this.fileSystemManager.getBackupFolder().toString(), backupVersion).toFile();
        if (!backupFolder.exists()) {
            throw new ResourceNotFoundException("backup");
        }
        FolderProxy.deleteFolder((File)backupFolder);
    }

    private List<FileItem> listBackupFiles(File backupFolder) {
        return this.platformFileManager.listIncludeToPlatformFiles(backupFolder);
    }

    @Generated
    public AdminBackupManager(AdminFileSystemManager fileSystemManager, AdminEzyPlatformFileManager platformFileManager) {
        this.fileSystemManager = fileSystemManager;
        this.platformFileManager = platformFileManager;
    }
}

