/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataAppender;

@EzySingleton
public class AdminDataAppenderManager {
    private final EzyLazyInitializer<Map<String, AdminDataAppender>> appenderByName = new EzyLazyInitializer(() -> singletonFactory.getSingletonsOf(AdminDataAppender.class).stream().collect(Collectors.toMap(AdminDataAppender::getName, it -> it, (o, n) -> n)));

    public AdminDataAppenderManager(EzySingletonFactory singletonFactory) {
    }

    public List<String> getSortedDataAppenderNames() {
        ArrayList<String> names = new ArrayList<String>(((Map)this.appenderByName.get()).keySet());
        names.sort(String::compareTo);
        return names;
    }

    public AdminDataAppender getDataAppenderByName(String name) {
        return (AdminDataAppender)((Object)((Map)this.appenderByName.get()).get(name));
    }

    public void startDataAppender(String dataAppenderName) {
        AdminDataAppender dataAppender = this.getDataAppenderByName(dataAppenderName);
        if (dataAppender != null) {
            dataAppender.start();
        }
    }

    public void restartDataAppender(String dataAppenderName) {
        AdminDataAppender dataAppender = this.getDataAppenderByName(dataAppenderName);
        if (dataAppender != null) {
            dataAppender.stop();
            dataAppender.start();
        }
    }

    public void stopDataAppender(String dataAppenderName) {
        AdminDataAppender dataAppender = this.getDataAppenderByName(dataAppenderName);
        if (dataAppender != null) {
            dataAppender.stop();
        }
    }

    public void reloadDataAppender(String dataAppenderName) {
        AdminDataAppender dataAppender = this.getDataAppenderByName(dataAppenderName);
        if (dataAppender != null) {
            dataAppender.reload();
        }
    }

    public boolean isDataAppenderStarted(String dataAppenderName) {
        AdminDataAppender dataAppender = this.getDataAppenderByName(dataAppenderName);
        return dataAppender != null && dataAppender.isStarted();
    }

    public boolean isDataAppenderRunnable(String dataAppenderName) {
        AdminDataAppender dataAppender = this.getDataAppenderByName(dataAppenderName);
        return dataAppender != null && dataAppender.isRunnable();
    }
}

