/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.EzyFutureTask;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.GetRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.properties.file.reader.FileReader;
import java.io.File;
import java.nio.file.AccessDeniedException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.bash.AdminBash;
import org.youngmonkeys.ezyplatform.admin.bash.AdminCommand;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEnvironmentManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformBackupWriter;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMarketUrlManager;
import org.youngmonkeys.ezyplatform.exception.FilePermissionException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.io.ZipFileProxy;

@EzySingleton
public class AdminEzyPlatformManager
extends EzyLoggable {
    private final AdminBash bash;
    private final HttpClient httpClient;
    private final FileReader propertiesFileReader;
    private final AdminMarketUrlManager marketUrlManager;
    private final AdminEnvironmentManager environmentManager;
    private final AdminFileSystemManager fileSystemManager;
    private final AdminEzyPlatformBackupWriter ezyPlatformBackupWriter;
    private final AtomicReference<String> latestVersionRef = new AtomicReference();
    private static final int UPDATE_PLATFORM_TIME_OUT = 900000;

    public void cacheLatestPlatformVersionAsync() {
        Thread newThread = new Thread(this::cacheLatestPlatformVersion);
        newThread.setName("fetch-ezyplatform-latest-version");
        newThread.start();
    }

    public String cacheLatestPlatformVersion() {
        try {
            Map response = (Map)this.httpClient.call((Request)((GetRequest)new GetRequest().setURL(this.marketUrlManager.getPlatformVersionNameUrl())).setResponseType(Map.class));
            this.latestVersionRef.set((String)response.get("version"));
        }
        catch (Exception e) {
            this.logger.info("can not get platform latest version due to: {} ({})", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        return this.getLatestVersion();
    }

    public String getLatestVersion() {
        String latestVersion = this.latestVersionRef.get();
        return latestVersion != null ? latestVersion : this.environmentManager.getPlatformVersion();
    }

    public boolean hasNewVersion() {
        return !this.getLatestVersion().equals(this.environmentManager.getPlatformVersion());
    }

    public String getDownloadedVersion() {
        File platformPropertiesFile = this.fileSystemManager.getNewEzyPlatformPropertiesFile();
        if (platformPropertiesFile.exists()) {
            Properties properties = this.propertiesFileReader.read(platformPropertiesFile);
            return properties.getProperty("ezyplatform.version");
        }
        return null;
    }

    public void downloadPlatform() throws Exception {
        EzyFutureTask future = new EzyFutureTask();
        Thread newThread = new Thread(() -> this.lambda$downloadPlatform$0((EzyFuture)future));
        newThread.setName("download-ezyplatform");
        newThread.start();
        future.get(900000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownloadPlatform() throws Exception {
        String fileName;
        String latestVersion = this.getLatestVersion();
        this.logger.info("start download ezyplatform {}", (Object)latestVersion);
        String downloadFileUrl = this.marketUrlManager.getDownloadPlatformUrl(latestVersion);
        File uploadPlatformsFolder = this.fileSystemManager.getUploadPlatformsFolder();
        try {
            fileName = this.httpClient.download(downloadFileUrl, uploadPlatformsFolder);
            this.logger.info("finished download ezyplatform {}", (Object)latestVersion);
        }
        catch (AccessDeniedException e) {
            throw FilePermissionException.fromFileAction((File)new File(e.getFile()), (String)"create/write/delete");
        }
        File projectBundleFile = Paths.get(uploadPlatformsFolder.toString(), fileName).toFile();
        try {
            this.logger.info("unzip ezyplatform {}", (Object)latestVersion);
            ZipFileProxy.unzipFile((File)uploadPlatformsFolder, (File)projectBundleFile);
        }
        catch (Exception e) {
            this.logger.info("unzip ezyplatform {} failed", (Object)latestVersion, (Object)e);
            FolderProxy.deleteFolder((File)this.fileSystemManager.getNewEzyPlatformFolder());
        }
        finally {
            this.logger.info("delete ezyplatform update bundle");
            FolderProxy.deleteFile((File)projectBundleFile);
        }
    }

    public void installPlatform() throws Exception {
        EzyFutureTask future = new EzyFutureTask();
        Thread newThread = new Thread(() -> this.lambda$installPlatform$1((EzyFuture)future));
        newThread.setName("install-ezyplatform");
        newThread.start();
        future.get(900000L);
    }

    public void prepareToInstallPlatform() throws Exception {
        this.logger.info("backup platform");
        this.ezyPlatformBackupWriter.backup();
        this.logger.info("replace update scripts");
        this.replaceUpdateToolsAndScripts();
    }

    private void doInstallPlatform() throws Exception {
        this.prepareToInstallPlatform();
        this.logger.info("run update script");
        this.bash.run(AdminCommand.UPDATE);
    }

    private void replaceUpdateToolsAndScripts() {
        File homeFolder = this.fileSystemManager.getEzyHomePath();
        File ezyPlatformFolder = this.fileSystemManager.getNewEzyPlatformFolder();
        for (String fileOrFolder : AdminFileSystemManager.TOOLS_AND_SCRIPT_PATHS) {
            File file = Paths.get(ezyPlatformFolder.toString(), fileOrFolder).toFile();
            if (!file.exists()) continue;
            if (file.isFile()) {
                FolderProxy.moveFile((File)file, (File)homeFolder);
                continue;
            }
            FolderProxy.copyFolder((File)file, (File)Paths.get(homeFolder.toString(), fileOrFolder).toFile());
        }
    }

    @Generated
    public AdminEzyPlatformManager(AdminBash bash, HttpClient httpClient, FileReader propertiesFileReader, AdminMarketUrlManager marketUrlManager, AdminEnvironmentManager environmentManager, AdminFileSystemManager fileSystemManager, AdminEzyPlatformBackupWriter ezyPlatformBackupWriter) {
        this.bash = bash;
        this.httpClient = httpClient;
        this.propertiesFileReader = propertiesFileReader;
        this.marketUrlManager = marketUrlManager;
        this.environmentManager = environmentManager;
        this.fileSystemManager = fileSystemManager;
        this.ezyPlatformBackupWriter = ezyPlatformBackupWriter;
    }

    private /* synthetic */ void lambda$installPlatform$1(EzyFuture future) {
        try {
            this.doInstallPlatform();
            future.setResult((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            future.setException(e);
        }
    }

    private /* synthetic */ void lambda$downloadPlatform$0(EzyFuture future) {
        try {
            this.doDownloadPlatform();
            future.setResult((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            future.setException(e);
        }
    }
}

