/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.pagination;

import com.tvd12.ezydata.database.query.EzyQueryConditionBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.time.LocalDateTime;
import org.youngmonkeys.ezyplatform.admin.pagination.AdminActivityFilter;

public class AdminAdminActivityFilter
implements AdminActivityFilter {
    public final Long adminId;
    public final String method;
    public final String keyword;
    public final LocalDateTime createdAtStartInclusive;
    public final LocalDateTime createdAtEndExclusive;
    public final LocalDateTime createdAtEndInclusive;

    protected AdminAdminActivityFilter(Builder builder) {
        this.adminId = builder.adminId;
        this.method = builder.method;
        this.keyword = builder.keyword;
        this.createdAtStartInclusive = builder.createdAtStartInclusive;
        this.createdAtEndExclusive = builder.createdAtEndExclusive;
        this.createdAtEndInclusive = builder.createdAtEndInclusive;
    }

    public String matchingCondition() {
        EzyQueryConditionBuilder answer = new EzyQueryConditionBuilder();
        if (this.adminId != null) {
            answer.and("e.adminId = :adminId");
        }
        if (this.method != null) {
            answer.and("e.method = :method");
        }
        if (this.keyword != null) {
            answer.and("e.uri LIKE CONCAT(:keyword, '%')");
        }
        if (this.createdAtStartInclusive != null) {
            answer.and("e.createdAt >= :createdAtStartInclusive");
        }
        if (this.createdAtEndExclusive != null) {
            answer.and("e.createdAt < :createdAtEndExclusive");
        }
        if (this.createdAtEndInclusive != null) {
            answer.and("e.createdAt <= :createdAtEndInclusive");
        }
        return answer.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<AdminAdminActivityFilter> {
        private Long adminId;
        private String method;
        private String keyword;
        private LocalDateTime createdAtStartInclusive;
        private LocalDateTime createdAtEndExclusive;
        private LocalDateTime createdAtEndInclusive;

        public Builder adminId(Long adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public Builder createdAtStartInclusive(LocalDateTime createdAtStartInclusive) {
            this.createdAtStartInclusive = createdAtStartInclusive;
            return this;
        }

        public Builder createdAtEndExclusive(LocalDateTime createdAtEndExclusive) {
            this.createdAtEndExclusive = createdAtEndExclusive;
            return this;
        }

        public Builder createdAtEndInclusive(LocalDateTime createdAtEndInclusive) {
            this.createdAtEndInclusive = createdAtEndInclusive;
            return this;
        }

        public AdminAdminActivityFilter build() {
            return new AdminAdminActivityFilter(this);
        }
    }
}

