/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Optional;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminMetaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.model.LoginFailuresModel;
import org.youngmonkeys.ezyplatform.util.Durations;
import org.youngmonkeys.ezyplatform.util.Numbers;

@Service
public class AdminLoginService {
    private final AdminSettingService settingService;
    private final AdminAdminMetaService adminMetaService;

    public int getBlockingLoginDurationInMinutes(long adminId) {
        return Durations.calculateDurationInMinute((long)System.currentTimeMillis(), (long)this.getLoginBlockUtil(adminId));
    }

    public LoginFailuresModel increaseLoginFailures(long adminId) {
        int maxLoginFailures = this.settingService.getAdminMaxLoginFailures();
        if (maxLoginFailures <= 0) {
            return LoginFailuresModel.builder().build();
        }
        long blockUtil = this.getLoginBlockUtil(adminId);
        long now = System.currentTimeMillis();
        int newLoginFailures = maxLoginFailures;
        int blockDuration = 0;
        if (now > blockUtil) {
            int loginFailures = this.getLoginFailures(adminId);
            newLoginFailures = loginFailures >= maxLoginFailures ? 1 : loginFailures + 1;
            this.adminMetaService.saveAdminMetaUniqueKey(adminId, "login_failures", newLoginFailures);
            if (newLoginFailures >= maxLoginFailures) {
                int blockDurationInMinute = this.settingService.getIntValue("admin_login_failure_block_durations");
                long newBlockUtil = now + (long)(blockDurationInMinute * 60) * 1000L;
                this.adminMetaService.saveAdminMetaUniqueKey(adminId, "login_blocked_util", newBlockUtil);
                blockDuration = Durations.calculateDurationInMinute((long)now, (long)newBlockUtil);
            }
        }
        return LoginFailuresModel.builder().loginFailures(newLoginFailures).blockDuration(blockDuration).maxLoginFailures(maxLoginFailures).build();
    }

    public void cleanLoginFailures(long adminId) {
        this.adminMetaService.saveAdminMetaUniqueKey(adminId, "login_failures", 0);
        this.adminMetaService.saveAdminMetaUniqueKey(adminId, "login_blocked_util", 0L);
    }

    public int getLoginFailures(long adminId) {
        return Optional.ofNullable(this.adminMetaService.getLatestMetaValueByAdminIdAndMetaKey(adminId, "login_failures")).map(Numbers::toIntOrZero).orElse(0);
    }

    public long getLoginBlockUtil(long adminId) {
        return Optional.ofNullable(this.adminMetaService.getLatestMetaValueByAdminIdAndMetaKey(adminId, "login_blocked_util")).map(Numbers::toLongOrZero).orElse(0L);
    }

    @Generated
    public AdminLoginService(AdminSettingService settingService, AdminAdminMetaService adminMetaService) {
        this.settingService = settingService;
        this.adminMetaService = adminMetaService;
    }
}

