/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.view;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.server.core.view.View;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.data.Target;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminTargetManager;
import org.youngmonkeys.ezyplatform.admin.view.AdminDashboardType;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewName;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;

@EzySingleton
public class AdminViewFactory {
    private final AdminModuleManager moduleManager;
    private final AdminTargetManager targetManager;
    private static final Map<ModuleType, String> MODULE_PARENT_MENUS = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.ADMIN_PLUGIN, (Object)"plugins").put((Object)ModuleType.WEB_PLUGIN, (Object)"plugins").put((Object)ModuleType.THEME, (Object)"home").put((Object)ModuleType.SOCKET_PLUGIN, (Object)"plugins").put((Object)ModuleType.SOCKET_APP, (Object)"home").build());
    private static final Map<ModuleType, String> MODULE_PARENT_URLS = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.ADMIN_PLUGIN, (Object)"plugins").put((Object)ModuleType.WEB_PLUGIN, (Object)"plugins").put((Object)ModuleType.THEME, (Object)"/").put((Object)ModuleType.SOCKET_PLUGIN, (Object)"plugins").put((Object)ModuleType.SOCKET_APP, (Object)"/").build());
    private static final Map<ModuleType, String> MODULE_CONTAINER_URLS = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.ADMIN_PLUGIN, (Object)"/admin-plugins").put((Object)ModuleType.WEB_PLUGIN, (Object)"/web-plugins").put((Object)ModuleType.THEME, (Object)"/themes").put((Object)ModuleType.SOCKET_PLUGIN, (Object)"/socket-plugins").put((Object)ModuleType.SOCKET_APP, (Object)"/socket-apps").build());
    private static final Map<ModuleType, String> MODULE_MENUS = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.ADMIN_PLUGIN, (Object)"plugins.admin").put((Object)ModuleType.WEB_PLUGIN, (Object)"plugins.web").put((Object)ModuleType.THEME, (Object)"themes").put((Object)ModuleType.SOCKET_PLUGIN, (Object)"plugins.socket").put((Object)ModuleType.SOCKET_APP, (Object)"socket.apps").build());
    private static final Map<AdminDashboardType, String> DASHBOARD_TEMPLATES = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)AdminDashboardType.WEB, (Object)"dashboards/web").put((Object)AdminDashboardType.SOCKET, (Object)"dashboards/socket").put((Object)AdminDashboardType.ADMIN, (Object)"dashboards/admin").build());

    public View.Builder newViewBuilder() {
        return View.builder();
    }

    public View.Builder newModuleDetailsViewBuilder(ModuleType moduleType, String moduleName) {
        Module module = this.moduleManager.getModule(moduleType, moduleName);
        if (module == null) {
            throw new ResourceNotFoundException("module");
        }
        String template = "modules/details";
        String rootMenu = MODULE_PARENT_MENUS.get(moduleType);
        String parentMenu = MODULE_MENUS.get(moduleType);
        String parentUrl = MODULE_CONTAINER_URLS.get(moduleType);
        String projectNewVersion = this.moduleManager.getProjectNewVersion(moduleName);
        boolean hasNewVersion = projectNewVersion != null;
        return this.newViewBuilder().template(template).addVariable("enableRestartToApplyButton", (Object)hasNewVersion).addVariable("newApplyItemVersion", (Object)projectNewVersion).addVariable("showRestartToApplyInfo", (Object)hasNewVersion).addVariable("moduleType", (Object)moduleType.getName()).addVariable("moduleName", (Object)moduleName).addVariable("moduleProjectName", (Object)module.getProjectName()).addVariable("currentOpen", (Object)rootMenu).addVariable("currentMenu", (Object)parentMenu).addVariable("currentParentTitle", (Object)(parentMenu + ".title")).addVariable("currentParentURL", (Object)parentUrl).addVariable("currentPageTitle", (Object)module.getProjectName());
    }

    public View.Builder newModulesViewBuilder(ModuleType moduleType) {
        List<Module> modules = moduleType == null ? this.moduleManager.getAllModules() : this.moduleManager.getModules(moduleType);
        modules.sort(Comparator.comparing(Module::getName));
        Map<String, String> projectNewVersions = this.moduleManager.getProjectNewVersions();
        Set<String> projectsContainsSqlScripts = this.moduleManager.filterProjectsContainsSqlScripts(modules);
        String parentMenu = "home";
        String parentUrl = "/";
        String currentMenu = "plugins";
        if (moduleType != null) {
            parentMenu = MODULE_PARENT_MENUS.get(moduleType);
            parentUrl = MODULE_PARENT_URLS.get(moduleType);
            currentMenu = MODULE_MENUS.get(moduleType);
        }
        return this.newViewBuilder().template("modules/list").addVariable("modules", modules).addVariable("projectNewVersions", projectNewVersions).addVariable("projectsContainsSqlScripts", projectsContainsSqlScripts).addVariable("enableAddNewButton", (Object)true).addVariable("moduleType", (Object)(moduleType != null ? moduleType.getName() : "")).addVariable("currentOpen", (Object)parentMenu).addVariable("currentMenu", (Object)currentMenu).addVariable("currentParentTitle", (Object)(parentMenu + ".title")).addVariable("currentParentURL", (Object)parentUrl).addVariable("currentPageTitle", (Object)(currentMenu + ".title"));
    }

    public View.Builder newDashboardViewBuilder(AdminDashboardType dashboardType) {
        String template = DASHBOARD_TEMPLATES.get((Object)dashboardType);
        String dashboardName = dashboardType.getName();
        Target target = this.targetManager.getTarget(TargetType.of((String)dashboardName));
        return this.newViewBuilder().template(template).addVariable("target", (Object)target).addVariable("currentOpen", (Object)"dashboard").addVariable("currentMenu", (Object)("dashboard." + dashboardName)).addVariable("currentParentTitle", (Object)"home.title").addVariable("currentParentURL", (Object)"/").addVariable("currentPageTitle", (Object)("dashboard." + dashboardName + ".title"));
    }

    public View.Builder newAdminsViewBuilder(AdminViewName viewName) {
        String vname;
        String viewTitle = vname = viewName.getName();
        String currentView = vname;
        String parentTitle = "admins.list.title";
        String parentUrl = "/admins";
        if (viewName == AdminViewName.LIST) {
            parentTitle = "dashboard.admin.title";
            parentUrl = "/dashboard/admin";
        } else if (viewName == AdminViewName.ROLE_DETAILS) {
            viewTitle = "role_details";
            currentView = "roles";
            parentTitle = "admins.roles.title";
            parentUrl = "/admins/roles";
        }
        return this.newViewBuilder().template("admins/" + vname).addVariable("currentOpen", (Object)"admins").addVariable("currentMenu", (Object)("admins." + currentView)).addVariable("currentParentTitle", (Object)parentTitle).addVariable("currentParentURL", (Object)parentUrl).addVariable("currentPageTitle", (Object)("admins." + viewTitle + ".title"));
    }

    public View.Builder newUsersViewBuilder(AdminViewName viewName) {
        String vname;
        String viewTitle = vname = viewName.getName();
        String currentView = vname;
        String parentTitle = "users.list.title";
        String parentUrl = "/users";
        if (viewName == AdminViewName.LIST) {
            parentTitle = "dashboard.title";
            parentUrl = "/";
        } else if (viewName == AdminViewName.ROLE_DETAILS) {
            viewTitle = "role_details";
            currentView = "roles";
            parentTitle = "users.roles.title";
            parentUrl = "/users/roles";
        }
        return this.newViewBuilder().template("users/" + vname).addVariable("currentOpen", (Object)"users").addVariable("currentMenu", (Object)("users." + currentView)).addVariable("currentParentTitle", (Object)parentTitle).addVariable("currentParentURL", (Object)parentUrl).addVariable("currentPageTitle", (Object)("users." + viewTitle + ".title"));
    }

    public View.Builder newSettingsViewBuilder(AdminViewName viewName) {
        String vname = viewName.getName();
        String parentTitle = "settings.title";
        String parentUrl = "/settings";
        if (viewName == AdminViewName.LIST) {
            parentTitle = "home.title";
            parentUrl = "/";
        }
        return this.newViewBuilder().template("settings/" + vname).addVariable("currentOpen", (Object)"settings").addVariable("currentMenu", (Object)("settings." + vname)).addVariable("currentParentTitle", (Object)parentTitle).addVariable("currentParentURL", (Object)parentUrl).addVariable("currentPageTitle", (Object)("settings." + vname + ".title"));
    }

    public View.Builder newModulesAddViewBuilder(ModuleType moduleType) {
        String parentMenu = "plugins";
        String parentUrl = "/plugins";
        String currentOpen = "plugins";
        if (moduleType != null) {
            parentMenu = MODULE_MENUS.get(moduleType);
            parentUrl = MODULE_CONTAINER_URLS.get(moduleType);
            if (moduleType == ModuleType.SOCKET_APP || moduleType == ModuleType.THEME) {
                currentOpen = parentMenu;
            }
        }
        return this.newViewBuilder().template("modules/add").addVariable("moduleType", (Object)(moduleType != null ? moduleType.getName() : "")).addVariable("currentOpen", (Object)currentOpen).addVariable("currentMenu", (Object)parentMenu).addVariable("currentParentTitle", (Object)(parentMenu + ".title")).addVariable("currentParentURL", (Object)parentUrl).addVariable("currentPageTitle", (Object)"modules.add.title");
    }

    @Generated
    public AdminViewFactory(AdminModuleManager moduleManager, AdminTargetManager targetManager) {
        this.moduleManager = moduleManager;
        this.targetManager = targetManager;
    }
}

