/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.codec.EzyMessageDeserializer;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.exception.EzyCodecException;
import com.tvd12.ezyfox.factory.EzyEntityFactory;
import com.tvd12.ezyfox.io.EzyByteBuffers;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public class JacksonSimpleDeserializer
implements EzyMessageDeserializer {
    protected final ObjectMapper objectMapper;

    public JacksonSimpleDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T deserialize(ByteBuffer buffer) {
        return this.deserialize(EzyByteBuffers.getBytes((ByteBuffer)buffer));
    }

    public <T> T deserialize(byte[] data) {
        return (T)this.parse(this.readTree(data));
    }

    public <T> T deserialize(String text) {
        return (T)this.parse(this.readTree(text));
    }

    protected JsonNode readTree(byte[] data) {
        try {
            return this.objectMapper.readTree(data);
        }
        catch (Exception e) {
            throw new EzyCodecException("read tree error", (Throwable)e);
        }
    }

    protected JsonNode readTree(String text) {
        try {
            return this.objectMapper.readTree(text);
        }
        catch (Exception e) {
            throw new EzyCodecException("read tree error", (Throwable)e);
        }
    }

    protected Object parse(JsonNode node) {
        if (node.isArray()) {
            return this.parseArray(node);
        }
        if (node.isObject()) {
            return this.parseObject(node);
        }
        if (node.isBoolean()) {
            return this.parseBoolean(node);
        }
        if (node.isNumber()) {
            return this.parseNumber(node);
        }
        if (node.isNull()) {
            return null;
        }
        return this.parseText(node);
    }

    protected String parseText(JsonNode node) {
        return node.asText();
    }

    protected Number parseNumber(JsonNode node) {
        return node.numberValue();
    }

    protected boolean parseBoolean(JsonNode node) {
        return node.asBoolean();
    }

    protected EzyArray parseArray(JsonNode node) {
        EzyArray array = EzyEntityFactory.newArray();
        for (JsonNode jsonNode : node) {
            array.add(this.parse(jsonNode));
        }
        return array;
    }

    protected EzyObject parseObject(JsonNode node) {
        EzyObject object = EzyEntityFactory.newObject();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            object.put(field.getKey(), this.parse((JsonNode)field.getValue()));
        }
        return object;
    }
}

