/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.settings;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.json.ObjectMapperBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.web.settings.ModuleMetadata;

public class WebModuleMetadataReader
extends EzyLoggable {
    private static final Map<ModuleType, String> METADATA_FILES = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.WEB_PLUGIN, (Object)"web/plugins.txt").put((Object)ModuleType.THEME, (Object)"web/themes.txt").build());

    public Map<ModuleType, Map<String, ModuleMetadata>> read(String ezyplatformHome) {
        File runtimeFolder = FileSystemManager.concatWithEzyHome((String)ezyplatformHome, (String)".runtime");
        return Stream.of(ModuleType.WEB_PLUGIN, ModuleType.THEME).collect(Collectors.toMap(it -> it, it -> this.readByTarget((ModuleType)it, runtimeFolder)));
    }

    private Map<String, ModuleMetadata> readByTarget(ModuleType moduleType, File runtimeFolder) {
        File modulesFile = this.getModuleMetadataFile(runtimeFolder, moduleType);
        ModuleMetadata[] moduleMetadataArray = modulesFile.exists() ? this.readModuleMetadata(modulesFile) : new ModuleMetadata[]{};
        return Arrays.stream(moduleMetadataArray).collect(Collectors.toMap(ModuleMetadata::getName, it -> it));
    }

    private ModuleMetadata[] readModuleMetadata(File metadataFile) {
        try {
            return (ModuleMetadata[])new ObjectMapperBuilder().build().readValue(metadataFile, ModuleMetadata[].class);
        }
        catch (IOException e) {
            return new ModuleMetadata[0];
        }
    }

    private File getModuleMetadataFile(File runtimeFolder, ModuleType moduleType) {
        return Paths.get(runtimeFolder.toString(), METADATA_FILES.get(moduleType)).toFile();
    }
}

