/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.command.impl;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.api.EzyResponseApi;
import com.tvd12.ezyfoxserver.command.EzyAbstractCommand;
import com.tvd12.ezyfoxserver.command.EzySendResponse;
import com.tvd12.ezyfoxserver.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.response.EzyResponse;
import com.tvd12.ezyfoxserver.setting.EzyLoggerSetting;
import com.tvd12.ezyfoxserver.socket.EzySimplePackage;
import java.util.Collection;
import java.util.Set;

public class EzySendResponseImpl
extends EzyAbstractCommand
implements EzySendResponse {
    protected final EzyServer server;
    protected final EzyLoggerSetting loggerSetting;
    protected final Set<EzyConstant> ignoredLogCommands;

    public EzySendResponseImpl(EzyServer server) {
        this.server = server;
        this.loggerSetting = server.getSettings().getLogger();
        this.ignoredLogCommands = this.loggerSetting.getIgnoredCommands().getCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(EzyResponse response, EzySession recipient, boolean encrypted, boolean immediate, EzyTransportType transportType) {
        boolean success = false;
        EzyResponseApi responseApi = this.server.getResponseApi();
        EzyArray data = (EzyArray)response.serialize();
        EzySimplePackage pack = this.newPackage(data, encrypted, transportType);
        pack.addRecipient(recipient);
        try {
            responseApi.response(pack, immediate);
            success = true;
        }
        catch (Exception e) {
            this.logger.error("send data: {}, to client: {} error", new Object[]{pack.getData(), recipient.getName(), e});
        }
        finally {
            pack.release();
        }
        boolean debug = this.server.getSettings().isDebug();
        if (debug && success && !this.ignoredLogCommands.contains(response.getCommand())) {
            this.logger.debug("send to: {} data: {}", (Object)recipient.getName(), (Object)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(EzyResponse response, Collection<EzySession> recipients, boolean encrypted, boolean immediate, EzyTransportType transportType) {
        boolean success = false;
        EzyResponseApi responseApi = this.server.getResponseApi();
        EzyArray data = (EzyArray)response.serialize();
        EzySimplePackage pack = this.newPackage(data, encrypted, transportType);
        pack.addRecipients(recipients);
        try {
            responseApi.response(pack, immediate);
            success = true;
        }
        catch (Exception e) {
            this.logger.error("send data: {}, to client: {} error", new Object[]{pack.getData(), this.getRecipientsNames(recipients), e});
        }
        finally {
            pack.release();
        }
        boolean debug = this.server.getSettings().isDebug();
        if (debug && success && !this.ignoredLogCommands.contains(response.getCommand())) {
            this.logger.debug("send to: {} data: {}", (Object)this.getRecipientsNames(recipients), (Object)data);
        }
    }

    protected EzySimplePackage newPackage(EzyArray data, boolean encrypted, EzyTransportType transportType) {
        EzySimplePackage pack = new EzySimplePackage();
        pack.setData(data);
        pack.setEncrypted(encrypted);
        pack.setTransportType(transportType);
        return pack;
    }

    protected String getRecipientsNames(Collection<EzySession> recipients) {
        StringBuilder builder = new StringBuilder().append("[ ");
        for (EzySession receiver : recipients) {
            builder.append(receiver.getName()).append(" ");
        }
        return builder.append("]").toString();
    }
}

