/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.socket.EzyPacket;
import com.tvd12.ezyfoxserver.socket.EzyPacketQueue;
import java.util.LinkedList;
import java.util.Queue;

public class EzyNonBlockingPacketQueue
extends EzyLoggable
implements EzyPacketQueue {
    private final int capacity;
    private final Queue<EzyPacket> queue;

    public EzyNonBlockingPacketQueue() {
        this(128);
    }

    public EzyNonBlockingPacketQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new LinkedList<EzyPacket>();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public EzyPacket take() {
        return this.queue.poll();
    }

    @Override
    public EzyPacket peek() {
        return this.queue.peek();
    }

    @Override
    public boolean isFull() {
        return this.queue.size() >= this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean add(EzyPacket packet) {
        if (this.isFull()) {
            return false;
        }
        return this.queue.offer(packet);
    }
}

