/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.concurrent.EzyThreadList;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStartable;

public abstract class EzySocketEventLoop
extends EzyLoggable
implements EzyStartable,
EzyDestroyable {
    protected volatile boolean active;
    protected EzyThreadList threadPool;

    protected abstract String threadName();

    protected abstract int threadPoolSize();

    public void start() throws Exception {
        this.initThreadPool();
        this.setActive(true);
        this.startLoopService();
    }

    protected void setActive(boolean value) {
        this.active = value;
    }

    private void startLoopService() {
        this.threadPool.execute();
    }

    private Runnable newServiceTask() {
        return this::eventLoop;
    }

    protected abstract void eventLoop();

    protected void initThreadPool() {
        this.threadPool = new EzyThreadList(this.threadPoolSize(), this.newServiceTask(), this.threadName());
    }

    public void destroy() {
        EzyProcessor.processWithLogException(this::doDestroy);
    }

    protected void doDestroy() {
        this.setActive(false);
        this.threadPool.interrupt();
    }
}

