/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.ssl;

import com.tvd12.ezyfox.stream.EzyAnywayInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreamReader;
import com.tvd12.ezyfox.stream.EzySimpleInputStreamReader;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.ssl.EzySslConfig;
import com.tvd12.ezyfoxserver.ssl.EzySslContextFactory;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class EzySimpleSslContextFactory
extends EzyLoggable
implements EzySslContextFactory {
    protected static final String SUNX509 = "SunX509";
    protected static final String PROTOCOL = "TLS";
    protected static final String JKS_KEYSTORE = "JKS";

    @Override
    public SSLContext newSslContext(EzySslConfig config) throws Exception {
        InputStream keyStoreStream = this.loadKeyStoreStream(config.getKeyStoreFile());
        char[] keyStorePassword = this.getPassword(config.getKeyStorePasswordFile());
        char[] certificatePassword = this.getPassword(config.getCertificatePasswordFile());
        KeyStore keyStore = this.newKeyStore(config);
        this.loadKeyStore(keyStore, keyStoreStream, keyStorePassword);
        KeyManagerFactory keyManagerFactory = this.newKeyManagerFactory(config);
        this.initKeyManagerFactory(keyManagerFactory, keyStore, certificatePassword);
        TrustManagerFactory trustManagerFactory = this.newTrustManagerFactory(config);
        this.initTrustManagerFactory(trustManagerFactory, keyStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext context = SSLContext.getInstance(this.getProtocol());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    protected void initKeyManagerFactory(KeyManagerFactory factory, KeyStore keyStore, char[] password) throws Exception {
        factory.init(keyStore, password);
    }

    protected KeyManagerFactory newKeyManagerFactory(EzySslConfig config) throws Exception {
        return KeyManagerFactory.getInstance(this.getAlgorithm(config));
    }

    protected void initTrustManagerFactory(TrustManagerFactory factory, KeyStore keyStore) throws Exception {
        factory.init(keyStore);
    }

    protected TrustManagerFactory newTrustManagerFactory(EzySslConfig config) throws Exception {
        return TrustManagerFactory.getInstance(this.getAlgorithm(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeyStore(KeyStore keyStore, InputStream stream, char[] password) throws Exception {
        try {
            keyStore.load(stream, password);
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] getPassword(String file) throws Exception {
        char[] answer;
        try (InputStream stream = this.newInputStreamLoader().load(file);){
            answer = this.newInputStreamReader().readString(stream, "UTF-8").trim().toCharArray();
        }
        return answer;
    }

    protected InputStream loadKeyStoreStream(String file) {
        return this.newInputStreamLoader().load(file);
    }

    protected KeyStore newKeyStore(EzySslConfig config) throws KeyStoreException {
        return KeyStore.getInstance(this.getKeyStoreType());
    }

    protected String getKeyStoreType() {
        return JKS_KEYSTORE;
    }

    protected String getProtocol() {
        return PROTOCOL;
    }

    protected String getAlgorithm(EzySslConfig config) {
        String algorithm = this.getDefaultAlgorithm();
        return algorithm != null ? algorithm : SUNX509;
    }

    protected String getDefaultAlgorithm() {
        return KeyManagerFactory.getDefaultAlgorithm();
    }

    protected EzyInputStreamLoader newInputStreamLoader() {
        return EzyAnywayInputStreamLoader.builder().context(this.getClass()).build();
    }

    protected EzyInputStreamReader newInputStreamReader() {
        return EzySimpleInputStreamReader.builder().build();
    }
}

