/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.ssl;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.util.EzyReturner;
import com.tvd12.ezyfoxserver.setting.EzySslConfigSetting;
import com.tvd12.ezyfoxserver.ssl.EzySslConfig;
import com.tvd12.ezyfoxserver.ssl.EzySslConfigLoader;
import com.tvd12.ezyfoxserver.ssl.EzySslContextFactory;
import com.tvd12.ezyfoxserver.ssl.EzySslContextFactoryBuilder;
import java.nio.file.Paths;
import javax.net.ssl.SSLContext;

public class EzySslContextInitializer {
    protected String homeFolderPath;
    protected EzySslConfigSetting sslConfig;

    protected EzySslContextInitializer(Builder builder) {
        this.sslConfig = builder.sslConfig;
        this.homeFolderPath = builder.homeFolderPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SSLContext init() {
        return this.newSslContext();
    }

    protected SSLContext newSslContext() {
        EzySslConfig config = this.loadSslConfig();
        EzySslContextFactoryBuilder builder = this.newSslContextFactoryBuilder();
        EzySslContextFactory factory = (EzySslContextFactory)builder.build();
        return (SSLContext)EzyReturner.returnWithException(() -> factory.newSslContext(config));
    }

    protected EzySslConfig loadSslConfig() {
        String file = this.getSslConfigFile();
        EzySslConfigLoader loader = this.newSslConfigLoader();
        return (EzySslConfig)loader.load(file);
    }

    protected EzySslContextFactoryBuilder newSslContextFactoryBuilder() {
        return (EzySslContextFactoryBuilder)EzyClasses.newInstance((String)this.sslConfig.getContextFactoryBuilder());
    }

    protected EzySslConfigLoader newSslConfigLoader() {
        return (EzySslConfigLoader)EzyClasses.newInstance((String)this.sslConfig.getLoader());
    }

    protected String getSslConfigFile() {
        return this.getPath(this.homeFolderPath, "settings", this.sslConfig.getFile());
    }

    protected String getPath(String first, String ... more) {
        return Paths.get(first, more).toString();
    }

    public static class Builder
    implements EzyBuilder<EzySslContextInitializer> {
        protected String homeFolderPath;
        protected EzySslConfigSetting sslConfig;

        public Builder homeFolderPath(String homeFolderPath) {
            this.homeFolderPath = homeFolderPath;
            return this;
        }

        public Builder sslConfig(EzySslConfigSetting sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public EzySslContextInitializer build() {
            return new EzySslContextInitializer(this);
        }
    }
}

