/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.websocket;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.nio.entity.EzyNioSession;
import com.tvd12.ezyfoxserver.nio.socket.EzySocketDataReceiver;
import com.tvd12.ezyfoxserver.nio.websocket.EzyWsChannel;
import com.tvd12.ezyfoxserver.nio.websocket.EzyWsCloseStatus;
import com.tvd12.ezyfoxserver.nio.websocket.EzyWsHandlerGroup;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyNioSessionManager;
import com.tvd12.ezyfoxserver.setting.EzySessionManagementSetting;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class EzyWsHandler
extends EzyLoggable {
    private final EzySocketDataReceiver socketDataReceiver;
    private final EzyNioSessionManager sessionManager;
    private final EzyHandlerGroupManager handlerGroupManager;
    private final EzySessionManagementSetting sessionManagementSetting;
    private static final Set<Integer> IGNORE_STATUS_CODES = Sets.newHashSet((Object[])new Integer[]{EzyWsCloseStatus.CLOSE_BY_SERVER.getCode()});

    public EzyWsHandler(Builder builder) {
        this.socketDataReceiver = builder.socketDataReceiver;
        this.sessionManager = builder.sessionManager;
        this.handlerGroupManager = builder.handlerGroupManager;
        this.sessionManagementSetting = builder.sessionManagementSetting;
    }

    public static Builder builder() {
        return new Builder();
    }

    private boolean isIgnoreStatusCode(int statusCode) {
        return IGNORE_STATUS_CODES.contains(statusCode);
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        this.logger.debug("close session: {}, statusCode = {}, reason = {}", new Object[]{session.getRemoteAddress(), statusCode, reason});
        if (this.isIgnoreStatusCode(statusCode)) {
            return;
        }
        this.setChannelClosed(session);
        this.socketDataReceiver.wsCloseConnection(session);
    }

    @OnWebSocketError
    public void onError(Session session, Throwable throwable) {
        EzyWsHandlerGroup dataHandler = (EzyWsHandlerGroup)this.handlerGroupManager.getHandlerGroup(session);
        if (dataHandler == null) {
            this.logger.debug("error on session: {}, but data handler removed", (Object)session.getRemoteAddress(), (Object)throwable);
        }
        if (throwable instanceof TimeoutException) {
            this.logger.debug("session {}: Timeout on Read", (Object)session.getRemoteAddress());
        } else if (dataHandler != null) {
            this.logger.debug("error on session: {}", (Object)session.getRemoteAddress(), (Object)throwable);
            dataHandler.fireExceptionCaught(throwable);
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        long sessionMaxIdleTime = this.sessionManagementSetting.getSessionMaxIdleTime();
        session.setIdleTimeout(sessionMaxIdleTime);
        EzyWsChannel channel = new EzyWsChannel(session);
        this.handlerGroupManager.newHandlerGroup(channel, EzyConnectionType.WEBSOCKET);
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) {
        this.socketDataReceiver.wsReceive(session, message);
    }

    @OnWebSocketMessage
    public void onMessage(Session session, byte[] payload, int offset, int len) {
        this.socketDataReceiver.wsReceive(session, payload, offset, len);
    }

    private void setChannelClosed(Session connection) {
        EzyWsChannel channel;
        EzyNioSession session = (EzyNioSession)this.sessionManager.getSession(connection);
        if (session != null && (channel = (EzyWsChannel)session.getChannel()) != null) {
            channel.setClosed();
        }
    }

    public static class Builder
    implements EzyBuilder<EzyWsHandler> {
        private EzySocketDataReceiver socketDataReceiver;
        private EzyNioSessionManager sessionManager;
        private EzyHandlerGroupManager handlerGroupManager;
        private EzySessionManagementSetting sessionManagementSetting;

        public Builder socketDataReceiver(EzySocketDataReceiver socketDataReceiver) {
            this.socketDataReceiver = socketDataReceiver;
            return this;
        }

        public Builder sessionManager(EzyNioSessionManager sessionManager) {
            this.sessionManager = sessionManager;
            return this;
        }

        public Builder handlerGroupManager(EzyHandlerGroupManager handlerGroupManager) {
            this.handlerGroupManager = handlerGroupManager;
            return this;
        }

        public Builder sessionManagementSetting(EzySessionManagementSetting sessionManagementSetting) {
            this.sessionManagementSetting = sessionManagementSetting;
            return this;
        }

        public EzyWsHandler build() {
            return new EzyWsHandler(this);
        }
    }
}

