/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.properties.file.reader.BaseFileReader;
import com.tvd12.properties.file.reader.FileReader;
import java.io.File;
import java.nio.file.Paths;
import java.util.Properties;
import org.youngmonkeys.ezyplatform.cli.util.DatabaseConnectonProxy;
import org.youngmonkeys.ezyplatform.cli.util.FileUtil;

public class Setup {
    protected final File setupPropertiesFile;
    protected final FileReader propertiesFileReader = new BaseFileReader();

    public Setup() {
        this.setupPropertiesFile = Paths.get("settings", "setup.properties").toFile();
    }

    public boolean run() {
        Properties properties = this.readSetupFile();
        boolean isContinue = this.setupDatabaseConnection(properties);
        if (!isContinue) {
            return false;
        }
        if (this.testConnection()) {
            return true;
        }
        System.err.println("Can not start cli, please update file: " + this.setupPropertiesFile + " manually");
        return false;
    }

    private boolean setupDatabaseConnection(Properties properties) {
        String driver = properties.getProperty("datasource.driver_class_name");
        String jdbcUrl = properties.getProperty("datasource.jdbc_url");
        if (EzyStrings.isNotBlank((String)driver) && EzyStrings.isNotBlank((String)jdbcUrl)) {
            return true;
        }
        System.err.println("You need setup database connection first, please update file: " + this.setupPropertiesFile + " manually");
        return false;
    }

    private boolean testConnection() {
        try {
            return (Boolean)DatabaseConnectonProxy.getInstance().submit(connection -> {
                connection.createStatement().execute("SELECT 1");
                System.out.println("Test database connection: OK");
                return true;
            });
        }
        catch (Exception e) {
            System.out.println("Test database connection failed: " + e.getClass().getName() + " (" + e.getMessage() + ")");
            return false;
        }
    }

    private Properties readSetupFile() {
        FileUtil.createFile(this.setupPropertiesFile);
        return this.propertiesFileReader.read(this.setupPropertiesFile);
    }
}

