/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.client.request;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyhttp.core.data.MultiValueMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RequestEntity {
    protected final Object body;
    protected final MultiValueMap headers;

    public RequestEntity(MultiValueMap headers, Object body) {
        this.body = body;
        this.headers = headers;
    }

    public RequestEntity(Map<String, List<String>> headers, Object body) {
        this(headers != null ? new MultiValueMap(headers) : null, body);
    }

    public static Builder of(Object body) {
        return RequestEntity.builder().body(body);
    }

    public static RequestEntity body(Object body) {
        return new RequestEntity((MultiValueMap)null, body);
    }

    public <T> T getBody() {
        return (T)this.body;
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getValue(name);
    }

    public String getContentType() {
        if (this.headers == null) {
            return "application/json";
        }
        return this.headers.getValue("Content-Type", "application/json");
    }

    public String toString() {
        return "RequestEntity(headers: " + this.headers + ", body: " + (this.body != null ? this.body.getClass().getSimpleName() : "null") + ")";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public MultiValueMap getHeaders() {
        return this.headers;
    }

    public static class Builder
    implements EzyBuilder<RequestEntity> {
        protected Object body;
        protected Map<String, List<String>> headers;

        public Builder body(Object body) {
            if (body != null) {
                this.body = body instanceof MultiValueMap ? ((MultiValueMap)body).toMap() : body;
            }
            return this;
        }

        public Builder header(String name, String value) {
            if (value == null) {
                return this;
            }
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder header(String name, List<String> values) {
            for (String value : values) {
                this.header(name, value);
            }
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.header(header.getKey(), header.getValue());
            }
            return this;
        }

        public Builder accept(String contentEncoding) {
            return this.header("Accept-Encoding", contentEncoding);
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public RequestEntity build() {
            return new RequestEntity(this.headers, this.body);
        }
    }
}

