/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.io.EzyStrings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public final class EzyDates {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "HH:mm:ss:SSS";
    public static final String TIME_PATTERN_STANDARD = "HH:mm:ss.SSS";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss:SSS";
    public static final String DATE_TIME_PATTERN_STANDARD = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String DATE_TIME_PATTERN_YYYYMMDD_HHMMSS = "yyyy-MM-dd'T'HH:mm:ss";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = EzyDates.getDateTimeFormatter(EzyDates.getPattern());
    public static final DateTimeFormatter DATE_TIME_FORMATTER_STANDARD = EzyDates.getDateTimeFormatter(EzyDates.getPatternStandard());
    public static final DateTimeFormatter DATE_TIME_FORMATTER_YYYYMMDD_HHMMSS = EzyDates.getDateTimeFormatter("yyyy-MM-dd'T'HH:mm:ss");
    private static final String[] DATE_TIME_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss:SSS", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss"};

    private EzyDates() {
    }

    public static String format(TemporalAccessor temporal) {
        return EzyDates.format(temporal, EzyDates.getDateTimeFormatter());
    }

    public static String format(TemporalAccessor temporal, String pattern) {
        return EzyDates.format(temporal, EzyDates.getDateTimeFormatter(pattern));
    }

    public static String format(TemporalAccessor temporal, DateTimeFormatter formatter) {
        return temporal == null ? null : formatter.format(temporal);
    }

    public static LocalDate parseDate(String source) {
        return EzyDates.parseDate(source, DATE_PATTERN);
    }

    public static LocalDate parseDate(String source, String pattern) {
        return EzyDates.parseDate(source, EzyDates.getDateTimeFormatter(pattern));
    }

    public static LocalDate parseDate(String source, DateTimeFormatter formatter) {
        return LocalDate.parse(source, formatter);
    }

    public static LocalTime parseTime(String source) {
        try {
            return EzyDates.parseTime(source, TIME_PATTERN);
        }
        catch (Exception e) {
            return EzyDates.parseTime(source, TIME_PATTERN_STANDARD);
        }
    }

    public static LocalTime parseTime(String source, String pattern) {
        return EzyDates.parseTime(source, EzyDates.getDateTimeFormatter(pattern));
    }

    public static LocalTime parseTime(String source, DateTimeFormatter formatter) {
        return LocalTime.parse(source, formatter);
    }

    public static LocalDateTime parseDateTime(String source) {
        try {
            return EzyDates.parseDateTime(source, EzyDates.getDateTimeFormatter());
        }
        catch (Exception e) {
            try {
                return EzyDates.parseDateTime(source, EzyDates.getDateTimeFormatterStandard());
            }
            catch (Exception e2) {
                try {
                    return EzyDates.parseDateTime(source, DATE_TIME_FORMATTER_YYYYMMDD_HHMMSS);
                }
                catch (Exception e3) {
                    throw new IllegalArgumentException("invalid date value: " + source + ", format must be of one " + EzyStrings.join(DATE_TIME_PATTERNS, ", "));
                }
            }
        }
    }

    public static LocalDateTime parseDateTime(String source, String pattern) {
        return EzyDates.parseDateTime(source, EzyDates.getDateTimeFormatter(pattern));
    }

    public static LocalDateTime parseDateTime(String source, DateTimeFormatter formatter) {
        return LocalDateTime.parse(source, formatter);
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return DATE_TIME_FORMATTER;
    }

    public static DateTimeFormatter getDateTimeFormatterStandard() {
        return DATE_TIME_FORMATTER_STANDARD;
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static Instant toInstant(LocalDate localDate) {
        return EzyDates.toInstant(localDate, ZoneId.systemDefault());
    }

    public static Instant toInstant(LocalDate localDate, ZoneId zoneId) {
        return localDate.atStartOfDay().atZone(zoneId).toInstant();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return EzyDates.toInstant(localDateTime, ZoneId.systemDefault());
    }

    public static Instant toInstant(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toInstant();
    }

    public static Date toDate(LocalDate localDate) {
        return EzyDates.toDate(localDate, ZoneId.systemDefault());
    }

    public static Date toDate(LocalDate localDate, ZoneId zoneId) {
        return Date.from(EzyDates.toInstant(localDate, zoneId));
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return EzyDates.toDate(localDateTime, ZoneId.systemDefault());
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneId zoneId) {
        return Date.from(EzyDates.toInstant(localDateTime, zoneId));
    }

    public static String format(long millis) {
        return EzyDates.format(millis, EzyDates.getPattern());
    }

    public static String format(Date date) {
        return EzyDates.format(date, EzyDates.getPattern());
    }

    public static Date parse(String source) {
        try {
            return EzyDates.parse(source, EzyDates.getPattern());
        }
        catch (Exception e) {
            try {
                return EzyDates.parse(source, EzyDates.getPatternStandard());
            }
            catch (Exception e2) {
                try {
                    return EzyDates.parse(source, DATE_TIME_PATTERN_YYYYMMDD_HHMMSS);
                }
                catch (Exception e3) {
                    throw new IllegalArgumentException("invalid date value: " + source + ", format must be one of " + EzyStrings.join(DATE_TIME_PATTERNS, ", "));
                }
            }
        }
    }

    public static Date parse(String source, String pattern) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            return formatter.parse(source);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String format(long millis, String pattern) {
        return EzyDates.format(new Date(millis), pattern);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    public static String getPattern() {
        return DATE_TIME_PATTERN;
    }

    public static String getPatternStandard() {
        return DATE_TIME_PATTERN_STANDARD;
    }

    public static boolean between(Date date, Date before, Date after) {
        long time = date.getTime();
        return time >= before.getTime() && time <= after.getTime();
    }

    public static int formatAsInteger(Date date) {
        LocalDateTime dateTime = EzyDates.dateToDateTime(date);
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        return year * 10000 + month * 100 + day;
    }

    public static LocalDateTime dateToDateTime(Date date) {
        return EzyDates.millisToDateTime(date.getTime());
    }

    public static LocalDateTime millisToDateTime(long millis) {
        return EzyDates.millisToDateTime(millis, ZoneId.systemDefault());
    }

    public static LocalDateTime millisToDateTime(long millis, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(millis);
        return EzyDates.instantToDateTime(instant, zoneId);
    }

    public static LocalDateTime instantToDateTime(Instant instant) {
        return EzyDates.instantToDateTime(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime instantToDateTime(Instant instant, ZoneId zoneId) {
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static Date parseToDateOrNull(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof String) {
            return EzyDates.parse((String)value);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof Instant) {
            return Date.from((Instant)value);
        }
        if (value instanceof LocalDate) {
            return EzyDates.toDate((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return EzyDates.toDate((LocalDateTime)value);
        }
        return null;
    }

    public static Instant parseToInstantOrNull(Object value) {
        if (value instanceof Date) {
            return ((Date)value).toInstant();
        }
        if (value instanceof String) {
            return EzyDates.parse((String)value).toInstant();
        }
        if (value instanceof Number) {
            return Instant.ofEpochMilli(((Number)value).longValue());
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof LocalDate) {
            return EzyDates.toInstant((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return EzyDates.toInstant((LocalDateTime)value);
        }
        return null;
    }

    public static LocalDate parseToLocalDateOrNull(Object value) {
        if (value instanceof Date) {
            return EzyDates.dateToDateTime((Date)value).toLocalDate();
        }
        if (value instanceof String) {
            return EzyDates.parseDate((String)value);
        }
        if (value instanceof Number) {
            return EzyDates.millisToDateTime(((Number)value).longValue()).toLocalDate();
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        return null;
    }

    public static LocalTime parseToLocalTimeOrNull(Object value) {
        if (value instanceof Date) {
            return EzyDates.dateToDateTime((Date)value).toLocalTime();
        }
        if (value instanceof String) {
            return EzyDates.parseTime((String)value);
        }
        if (value instanceof Number) {
            return EzyDates.millisToDateTime(((Number)value).longValue()).toLocalTime();
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(ZoneId.systemDefault()).toLocalTime();
        }
        if (value instanceof LocalDate) {
            return LocalTime.of(0, 0);
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalTime();
        }
        return null;
    }

    public static LocalDateTime parseToLocalDateTimeOrNull(Object value) {
        if (value instanceof Date) {
            return EzyDates.dateToDateTime((Date)value);
        }
        if (value instanceof String) {
            return EzyDates.parseDateTime((String)value);
        }
        if (value instanceof Number) {
            return EzyDates.millisToDateTime(((Number)value).longValue());
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), 0, 0);
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        return null;
    }
}

