/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.concurrent;

import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.exception.EzyFutureTaskCancelledException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class EzyFutureTask
implements EzyFuture {
    protected Object result;
    protected Exception exception;
    protected volatile boolean done;
    protected static final long NO_TIMEOUT = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResult(Object result) {
        if (result == null) {
            throw new NullPointerException("result is null");
        }
        EzyFutureTask ezyFutureTask = this;
        synchronized (ezyFutureTask) {
            if (this.result == null) {
                this.result = result;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setException(Exception exception) {
        if (exception == null) {
            throw new NullPointerException("exception is null");
        }
        EzyFutureTask ezyFutureTask = this;
        synchronized (ezyFutureTask) {
            if (this.exception == null) {
                this.exception = exception;
            }
            this.notify();
        }
    }

    @Override
    public void cancel(String message) {
        this.setException(new EzyFutureTaskCancelledException(message));
    }

    @Override
    public <V> V get() throws Exception {
        return this.get(-1L);
    }

    @Override
    public <V> V get(long timeout) throws Exception {
        EzyFutureTask ezyFutureTask = this;
        synchronized (ezyFutureTask) {
            if (this.hasNoData()) {
                if (timeout > 0L) {
                    this.wait(timeout);
                    if (this.hasNoData()) {
                        this.exception = new TimeoutException("timeout: " + timeout + "ms");
                    }
                } else {
                    this.wait();
                }
            }
            this.done = true;
            if (this.result != null) {
                return (V)this.result;
            }
            throw this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        EzyFutureTask ezyFutureTask = this;
        synchronized (ezyFutureTask) {
            return this.done;
        }
    }

    protected boolean hasNoData() {
        return this.result == null && this.exception == null;
    }

    @Override
    public <V> Future<V> toFuture() {
        return new Future<V>(){
            private final AtomicBoolean cancelled = new AtomicBoolean(false);

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.isDone()) {
                    return false;
                }
                EzyFutureTask.this.cancel("cancel the future: " + EzyFutureTask.this);
                this.cancelled.set(true);
                return true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled.get();
            }

            @Override
            public boolean isDone() {
                return EzyFutureTask.this.isDone();
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                try {
                    return EzyFutureTask.this.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    return EzyFutureTask.this.get(TimeUnit.MILLISECONDS.convert(timeout, unit));
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }
}

