/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.command.impl;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfoxserver.command.EzyAbstractCommand;
import com.tvd12.ezyfoxserver.command.EzyBroadcastAppsEvent;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyAppContexts;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.event.EzyEvent;
import java.util.function.Predicate;

public class EzyBroadcastAppsEventImpl
extends EzyAbstractCommand
implements EzyBroadcastAppsEvent {
    private final EzyZoneContext context;

    public EzyBroadcastAppsEventImpl(EzyZoneContext context) {
        this.context = context;
    }

    @Override
    public void fire(EzyConstant type, EzyEvent event, boolean catchException) {
        this.logger.debug("zone {} broadcast to apps event: {}", (Object)this.getZoneName(), (Object)type);
        for (EzyAppContext appContext : this.context.getAppContexts()) {
            this.fireAppEvent(appContext, type, event, catchException);
        }
    }

    @Override
    public void fire(EzyConstant type, EzyEvent event, String username, boolean catchException) {
        this.fire(type, event, (EzyAppContext appCtx) -> EzyAppContexts.containsUser(appCtx, username), catchException);
    }

    @Override
    public void fire(EzyConstant type, EzyEvent event, EzyUser user, boolean catchException) {
        this.fire(type, event, (EzyAppContext appCtx) -> EzyAppContexts.containsUser(appCtx, user), catchException);
    }

    @Override
    public void fire(EzyConstant type, EzyEvent event, Predicate<EzyAppContext> filter, boolean catchException) {
        this.logger.debug("zone {} broadcast to apps event: {}", (Object)this.getZoneName(), (Object)type);
        for (EzyAppContext appContext : this.context.getAppContexts()) {
            if (!filter.test(appContext)) continue;
            this.fireAppEvent(appContext, type, event, catchException);
        }
    }

    protected void fireAppEvent(EzyAppContext ctx, EzyConstant type, EzyEvent event, boolean catchException) {
        if (catchException) {
            try {
                ctx.handleEvent(type, event);
            }
            catch (Exception e) {
                ctx.handleException(Thread.currentThread(), e);
            }
        } else {
            ctx.handleEvent(type, event);
        }
    }

    protected String getZoneName() {
        return this.context.getZone().getSetting().getName();
    }
}

