/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.command.impl;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyExceptionHandlers;
import com.tvd12.ezyfox.util.EzyExceptionHandlersFetcher;
import com.tvd12.ezyfoxserver.command.EzyAbstractCommand;
import com.tvd12.ezyfoxserver.command.EzyHandleException;

public class EzyHandleExceptionImpl
extends EzyAbstractCommand
implements EzyHandleException {
    private final EzyExceptionHandlersFetcher fetcher;

    public EzyHandleExceptionImpl(EzyExceptionHandlersFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public void handle(Thread thread, Throwable throwable) {
        EzyExceptionHandlers handlers = this.fetcher.getExceptionHandlers();
        if (handlers.isEmpty()) {
            this.logger.info("there is no handler for exception: ", throwable);
        } else {
            try {
                handlers.handleException(thread, throwable);
            }
            catch (Exception e) {
                this.logger.warn("handle exception: {} error", (Object)EzyStrings.exceptionToSimpleString((Throwable)throwable), (Object)e);
            }
        }
    }
}

