/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.context;

import com.tvd12.ezyfoxserver.context.EzyAbstractContext;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyComplexContext;
import com.tvd12.ezyfoxserver.context.EzyPluginContext;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EzyAbstractComplexContext
extends EzyAbstractContext
implements EzyComplexContext {
    protected final Set<EzyAppContext> appContexts = new HashSet<EzyAppContext>();
    protected final Map<Integer, EzyAppContext> appContextsById = new ConcurrentHashMap<Integer, EzyAppContext>();
    protected final Set<EzyPluginContext> pluginContexts = new HashSet<EzyPluginContext>();
    protected final Map<Integer, EzyPluginContext> pluginContextsById = new ConcurrentHashMap<Integer, EzyPluginContext>();

    public void addAppContext(EzyAppSetting app, EzyAppContext appContext) {
        this.appContexts.add(appContext);
        this.appContextsById.put(app.getId(), appContext);
    }

    public void addAppContexts(Collection<EzyAppContext> appContexts) {
        for (EzyAppContext ctx : appContexts) {
            this.addAppContext(ctx.getApp().getSetting(), ctx);
        }
    }

    public void addPluginContext(EzyPluginSetting plugin, EzyPluginContext pluginContext) {
        this.pluginContexts.add(pluginContext);
        this.pluginContextsById.put(plugin.getId(), pluginContext);
    }

    public void addPluginContexts(Collection<EzyPluginContext> pluginContexts) {
        for (EzyPluginContext ctx : pluginContexts) {
            this.addPluginContext(ctx.getPlugin().getSetting(), ctx);
        }
    }

    @Override
    public EzyAppContext getAppContext(int appId) {
        EzyAppContext appContext = this.appContextsById.get(appId);
        if (appContext != null) {
            return appContext;
        }
        throw new IllegalArgumentException("has not app with id = " + appId);
    }

    @Override
    public Collection<EzyAppContext> getAppContexts() {
        return this.appContexts;
    }

    @Override
    public Collection<EzyPluginContext> getPluginContexts() {
        return this.pluginContexts;
    }

    @Override
    public EzyPluginContext getPluginContext(int pluginId) {
        EzyPluginContext pluginContext = this.pluginContextsById.get(pluginId);
        if (pluginContext != null) {
            return pluginContext;
        }
        throw new IllegalArgumentException("has not plugin with id = " + pluginId);
    }

    @Override
    public final void destroy() {
        super.destroy();
        this.destroyComponents();
        this.clearProperties();
        this.postDestroy();
    }

    protected void clearProperties() {
        this.appContexts.clear();
        this.pluginContexts.clear();
        this.appContextsById.clear();
        this.pluginContextsById.clear();
    }

    protected void destroyComponents() {
    }
}

