/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.statistics;

import com.tvd12.ezyfoxserver.statistics.EzyNetworkBytesFrame;
import com.tvd12.ezyfoxserver.statistics.EzyNetworkBytesFrameHour;
import com.tvd12.ezyfoxserver.statistics.EzyNetworkBytesFrameMinute;
import com.tvd12.ezyfoxserver.statistics.EzyNetworkBytesFrameSecond;
import com.tvd12.ezyfoxserver.statistics.EzyNetworkStats;
import java.io.Serializable;
import lombok.Generated;

public class EzySimpleNetworkStats
implements EzyNetworkStats,
Serializable {
    private static final long serialVersionUID = 6439136315133894536L;
    protected long readBytes;
    protected long writtenBytes;
    protected long droppedInBytes;
    protected long droppedOutBytes;
    protected long writeErrorBytes;
    protected long readPackets;
    protected long writtenPackets;
    protected long droppedInPackets;
    protected long droppedOutPackets;
    protected long writeErrorPackets;
    protected EzyNetworkBytesFrame frameHour = new EzyNetworkBytesFrameHour();
    protected EzyNetworkBytesFrame frameMinute = new EzyNetworkBytesFrameMinute();
    protected EzyNetworkBytesFrame frameSecond = new EzyNetworkBytesFrameSecond();

    @Override
    public void addReadBytes(long bytes) {
        this.readBytes += bytes;
        this.addReadBytesToFrames(bytes);
    }

    private void addReadBytesToFrames(long bytes) {
        if (this.frameSecond.isExpired()) {
            this.frameSecond = this.frameSecond.nextFrame();
        }
        this.frameSecond.addReadBytes(bytes);
        if (this.frameMinute.isExpired()) {
            this.frameMinute = this.frameMinute.nextFrame();
        }
        this.frameMinute.addReadBytes(bytes);
        if (this.frameHour.isExpired()) {
            this.frameHour = this.frameHour.nextFrame();
        }
        this.frameHour.addReadBytes(bytes);
    }

    @Override
    public void addWrittenBytes(long bytes) {
        this.writtenBytes += bytes;
        this.addWrittenBytesToFrames(bytes);
    }

    private void addWrittenBytesToFrames(long bytes) {
        if (this.frameSecond.isExpired()) {
            this.frameSecond = this.frameSecond.nextFrame();
        }
        this.frameSecond.addWrittenBytes(bytes);
        if (this.frameMinute.isExpired()) {
            this.frameMinute = this.frameMinute.nextFrame();
        }
        this.frameMinute.addWrittenBytes(bytes);
        if (this.frameHour.isExpired()) {
            this.frameHour = this.frameHour.nextFrame();
        }
        this.frameHour.addWrittenBytes(bytes);
    }

    @Override
    public void addDroppedInBytes(long bytes) {
        this.droppedInBytes += bytes;
    }

    @Override
    public void addDroppedOutBytes(long bytes) {
        this.droppedOutBytes += bytes;
    }

    @Override
    public void addWriteErrorBytes(long bytes) {
        this.writeErrorBytes += bytes;
    }

    @Override
    public long getReadBytesPerHour() {
        return this.frameHour.getReadBytes();
    }

    @Override
    public long getReadBytesPerMinute() {
        return this.frameMinute.getReadBytes();
    }

    @Override
    public long getReadBytesPerSecond() {
        return this.frameSecond.getReadBytes();
    }

    @Override
    public long getWrittenBytesPerHour() {
        return this.frameHour.getWrittenBytes();
    }

    @Override
    public long getWrittenBytesPerMinute() {
        return this.frameMinute.getWrittenBytes();
    }

    @Override
    public long getWrittenBytesPerSecond() {
        return this.frameSecond.getWrittenBytes();
    }

    @Override
    public void addReadPackets(long packets) {
        this.readPackets += packets;
    }

    @Override
    public void addWrittenPackets(long packets) {
        this.writtenPackets += packets;
    }

    @Override
    public void addDroppedInPackets(long packets) {
        this.droppedInPackets += packets;
    }

    @Override
    public void addDroppedOutPackets(long packets) {
        this.droppedOutPackets += packets;
    }

    @Override
    public void addWriteErrorPackets(long packets) {
        this.writeErrorPackets += packets;
    }

    @Override
    @Generated
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    @Generated
    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    @Override
    @Generated
    public long getDroppedInBytes() {
        return this.droppedInBytes;
    }

    @Generated
    public long getDroppedOutBytes() {
        return this.droppedOutBytes;
    }

    @Override
    @Generated
    public long getWriteErrorBytes() {
        return this.writeErrorBytes;
    }

    @Override
    @Generated
    public long getReadPackets() {
        return this.readPackets;
    }

    @Override
    @Generated
    public long getWrittenPackets() {
        return this.writtenPackets;
    }

    @Override
    @Generated
    public long getDroppedInPackets() {
        return this.droppedInPackets;
    }

    @Override
    @Generated
    public long getDroppedOutPackets() {
        return this.droppedOutPackets;
    }

    @Override
    @Generated
    public long getWriteErrorPackets() {
        return this.writeErrorPackets;
    }

    @Generated
    public EzyNetworkBytesFrame getFrameHour() {
        return this.frameHour;
    }

    @Generated
    public EzyNetworkBytesFrame getFrameMinute() {
        return this.frameMinute;
    }

    @Generated
    public EzyNetworkBytesFrame getFrameSecond() {
        return this.frameSecond;
    }
}

