/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.factory;

import com.tvd12.ezyfox.builder.EzyArrayBuilder;
import com.tvd12.ezyfox.builder.EzyObjectBuilder;
import com.tvd12.ezyfox.builder.EzySimpleArrayBuilder;
import com.tvd12.ezyfox.builder.EzySimpleObjectBuilder;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyArrayList;
import com.tvd12.ezyfox.entity.EzyHashMap;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.factory.EzyEntityCreator;
import com.tvd12.ezyfox.io.EzyCollectionConverter;
import com.tvd12.ezyfox.io.EzyInputTransformer;
import com.tvd12.ezyfox.io.EzyOutputTransformer;
import com.tvd12.ezyfox.io.EzySingletonCollectionConverter;
import com.tvd12.ezyfox.io.EzySingletonInputTransformer;
import com.tvd12.ezyfox.io.EzySingletonOutputTransformer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class EzySimpleEntityCreator
implements EzyEntityCreator {
    private final Map<Class, Supplier> suppliers = this.defaultSuppliers();
    private static final EzySimpleEntityCreator INSTANCE = new EzySimpleEntityCreator();

    private EzySimpleEntityCreator() {
    }

    public static EzySimpleEntityCreator getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> T create(Class<T> productType) {
        Supplier supplier = this.suppliers.get(productType);
        return supplier.get();
    }

    @Override
    public EzyObject newObject() {
        return new EzyHashMap(this.getInputTransformer(), this.getOutputTransformer());
    }

    @Override
    public EzyArray newArray() {
        return new EzyArrayList(this.getInputTransformer(), this.getOutputTransformer(), this.getCollectionConverter());
    }

    @Override
    public EzyObjectBuilder newObjectBuilder() {
        return new EzySimpleObjectBuilder(this.getInputTransformer(), this.getOutputTransformer());
    }

    @Override
    public EzyArrayBuilder newArrayBuilder() {
        return new EzySimpleArrayBuilder(this.getInputTransformer(), this.getOutputTransformer(), this.getCollectionConverter());
    }

    private EzyInputTransformer getInputTransformer() {
        return EzySingletonInputTransformer.getInstance();
    }

    private EzyOutputTransformer getOutputTransformer() {
        return EzySingletonOutputTransformer.getInstance();
    }

    private EzyCollectionConverter getCollectionConverter() {
        return EzySingletonCollectionConverter.getInstance();
    }

    private Map<Class, Supplier> defaultSuppliers() {
        ConcurrentHashMap<Class, Supplier> answer = new ConcurrentHashMap<Class, Supplier>();
        answer.put(EzyObject.class, this::newObject);
        answer.put(EzyArray.class, this::newArray);
        answer.put(EzyObjectBuilder.class, this::newObjectBuilder);
        answer.put(EzyArrayBuilder.class, this::newArrayBuilder);
        return answer;
    }
}

