/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.socket;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.nio.entity.EzyNioSession;
import com.tvd12.ezyfoxserver.nio.handler.EzyNioHandlerGroup;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioAcceptableConnectionsHandler;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSocketChannel;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManagerAware;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class EzyNioSocketAcceptor
extends EzySocketAbstractEventHandler
implements EzyHandlerGroupManagerAware,
EzyNioAcceptableConnectionsHandler {
    protected boolean tcpNoDelay;
    protected Selector ownSelector;
    protected Selector readSelector;
    protected EzyHandlerGroupManager handlerGroupManager;
    protected final List<SocketChannel> acceptableConnections = new ArrayList<SocketChannel>();
    protected final List<SocketChannel> acceptableConnectionsBuffer = new ArrayList<SocketChannel>();

    public void handleEvent() {
        try {
            this.processReadyKeys();
        }
        catch (Throwable e) {
            this.logger.info("I/O error at socket-acceptor", e);
        }
    }

    private void processReadyKeys() throws Exception {
        this.ownSelector.select();
        Set<SelectionKey> readyKeys = this.ownSelector.selectedKeys();
        Iterator<SelectionKey> iterator = readyKeys.iterator();
        while (iterator.hasNext()) {
            SelectionKey key = iterator.next();
            iterator.remove();
            this.processReadyKey(key);
        }
        this.readSelector.wakeup();
    }

    private void processReadyKey(SelectionKey key) throws Exception {
        if (key.isAcceptable()) {
            ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
            SocketChannel clientChannel = serverChannel.accept();
            this.addConnection(clientChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(SocketChannel clientChannel) {
        List<SocketChannel> list = this.acceptableConnections;
        synchronized (list) {
            this.acceptableConnections.add(clientChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAcceptableConnections() {
        List<SocketChannel> list = this.acceptableConnections;
        synchronized (list) {
            this.acceptableConnectionsBuffer.addAll(this.acceptableConnections);
            this.acceptableConnections.clear();
        }
        try {
            for (SocketChannel clientChannel : this.acceptableConnectionsBuffer) {
                this.acceptConnection(clientChannel);
            }
        }
        finally {
            this.acceptableConnectionsBuffer.clear();
        }
    }

    private void acceptConnection(SocketChannel clientChannel) {
        try {
            this.doAcceptConnection(clientChannel);
        }
        catch (Throwable e) {
            this.logger.info("can't accept connection: {}", (Object)clientChannel, (Object)e);
        }
    }

    private void doAcceptConnection(SocketChannel clientChannel) throws Exception {
        clientChannel.configureBlocking(false);
        clientChannel.socket().setTcpNoDelay(this.tcpNoDelay);
        SelectionKey selectionKey = clientChannel.register(this.readSelector, 1);
        EzyChannel channel = this.newChannel(clientChannel);
        EzyNioHandlerGroup handlerGroup = (EzyNioHandlerGroup)this.handlerGroupManager.newHandlerGroup(channel, EzyConnectionType.SOCKET);
        EzyNioSession session = handlerGroup.getSession();
        session.setProperty("SessionSelectionKey", selectionKey);
    }

    protected EzyChannel newChannel(SocketChannel clientChannel) {
        return new EzyNioSocketChannel(clientChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        List<SocketChannel> list = this.acceptableConnections;
        synchronized (list) {
            this.acceptableConnections.clear();
        }
        EzyProcessor.processWithLogException(this.ownSelector::close);
    }

    @Generated
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @Generated
    public void setOwnSelector(Selector ownSelector) {
        this.ownSelector = ownSelector;
    }

    @Generated
    public void setReadSelector(Selector readSelector) {
        this.readSelector = readSelector;
    }

    @Override
    @Generated
    public void setHandlerGroupManager(EzyHandlerGroupManager handlerGroupManager) {
        this.handlerGroupManager = handlerGroupManager;
    }
}

