/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.socket;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioAcceptableConnectionsHandler;
import com.tvd12.ezyfoxserver.nio.socket.EzySocketDataReceiver;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;

public class EzyNioSocketReader
extends EzySocketAbstractEventHandler {
    protected Selector ownSelector;
    protected EzySocketDataReceiver socketDataReceiver;
    protected EzyNioAcceptableConnectionsHandler acceptableConnectionsHandler;

    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.ownSelector.close());
    }

    public void handleEvent() {
        try {
            this.acceptableConnectionsHandler.handleAcceptableConnections();
            int readyKeyCount = this.ownSelector.selectNow();
            if (readyKeyCount > 0) {
                this.processReadyKeys();
            }
            Thread.sleep(3L);
        }
        catch (Throwable e) {
            this.logger.info("I/O error at socket-reader", e);
        }
    }

    protected void processReadyKeys() {
        Set<SelectionKey> readyKeys = this.ownSelector.selectedKeys();
        Iterator<SelectionKey> iterator = readyKeys.iterator();
        while (iterator.hasNext()) {
            SelectionKey key = iterator.next();
            iterator.remove();
            if (!key.isValid()) continue;
            try {
                this.processReadyKey(key);
            }
            catch (Throwable e) {
                this.logger.info("process ready key: {} error", (Object)key, (Object)e);
            }
        }
    }

    private void processReadyKey(SelectionKey key) {
        if (key.isWritable()) {
            key.interestOps(1);
        }
        if (key.isReadable()) {
            this.socketDataReceiver.tcpReceive((SocketChannel)key.channel());
        }
    }

    @Generated
    public void setOwnSelector(Selector ownSelector) {
        this.ownSelector = ownSelector;
    }

    @Generated
    public void setSocketDataReceiver(EzySocketDataReceiver socketDataReceiver) {
        this.socketDataReceiver = socketDataReceiver;
    }

    @Generated
    public void setAcceptableConnectionsHandler(EzyNioAcceptableConnectionsHandler acceptableConnectionsHandler) {
        this.acceptableConnectionsHandler = acceptableConnectionsHandler;
    }
}

