/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.socket;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.exception.EzyConnectionCloseException;
import com.tvd12.ezyfoxserver.nio.handler.EzyNioHandlerGroup;
import com.tvd12.ezyfoxserver.nio.websocket.EzyWsHandlerGroup;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import org.eclipse.jetty.websocket.api.Session;

public class EzySocketDataReceiver
extends EzyLoggable
implements EzyDestroyable {
    protected final int threadPoolSize;
    protected final ByteBuffer[] tcpByteBuffers;
    protected final ExecutorService[] executorServices;
    protected final EzyHandlerGroupManager handlerGroupManager;

    public EzySocketDataReceiver(Builder builder) {
        this.threadPoolSize = builder.threadPoolSize;
        this.handlerGroupManager = builder.handlerGroupManager;
        this.tcpByteBuffers = this.newTcpByteBuffers(this.threadPoolSize);
        this.executorServices = this.newExecutorServices(this.threadPoolSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected ByteBuffer[] newTcpByteBuffers(int size) {
        ByteBuffer[] answer = new ByteBuffer[size];
        for (int i = 0; i < size; ++i) {
            answer[i] = ByteBuffer.allocateDirect(this.getMaxBufferSize());
        }
        return answer;
    }

    private ExecutorService[] newExecutorServices(int threadPoolSize) {
        ExecutorService[] answer = new ExecutorService[threadPoolSize];
        for (int i = 0; i < threadPoolSize; ++i) {
            answer[i] = EzyExecutors.newSingleThreadExecutor((String)"socket-data-receiver");
        }
        return answer;
    }

    public void tcpReceive(SocketChannel channel) {
        int index = Math.abs(channel.hashCode() % this.threadPoolSize);
        ByteBuffer buffer = this.tcpByteBuffers[index];
        ExecutorService executorService = this.executorServices[index];
        executorService.execute(() -> this.doTcpReceive(channel, buffer));
    }

    private void doTcpReceive(SocketChannel channel, ByteBuffer buffer) {
        try {
            this.tcpReadBytes(channel, buffer);
        }
        catch (Throwable e) {
            this.logger.info("I/O error at tcp-data-reader (channel: {})", (Object)channel, (Object)e);
        }
    }

    protected void tcpReadBytes(SocketChannel channel, ByteBuffer buffer) throws Throwable {
        int readBytes = -1;
        Throwable exception = null;
        try {
            buffer.clear();
            readBytes = channel.read(buffer);
            if (readBytes > 0) {
                this.processTcpReadBytes(channel, buffer);
            }
        }
        catch (EzyConnectionCloseException e) {
            readBytes = -1;
            exception = e;
        }
        catch (Throwable e) {
            exception = e;
        }
        if (readBytes == -1) {
            this.tcpCloseConnection(channel);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void processTcpReadBytes(SocketChannel channel, ByteBuffer buffer) throws Exception {
        EzyNioHandlerGroup handlerGroup = (EzyNioHandlerGroup)this.handlerGroupManager.getHandlerGroup(channel);
        if (handlerGroup == null) {
            return;
        }
        buffer.flip();
        byte[] binary = this.readTcpBytesFromBuffer(handlerGroup.getChannel(), buffer);
        handlerGroup.fireBytesReceived(binary);
    }

    protected byte[] readTcpBytesFromBuffer(EzyChannel channel, ByteBuffer buffer) throws Exception {
        byte[] binary = new byte[buffer.limit()];
        buffer.get(binary);
        return binary;
    }

    private void tcpCloseConnection(SocketChannel channel) {
        Object handlerGroup = this.handlerGroupManager.getHandlerGroup(channel);
        if (handlerGroup != null) {
            handlerGroup.enqueueDisconnection();
        }
    }

    public void udpReceive(Object channel, EzyMessage message) {
        ExecutorService executorService = this.selectedExecutorService(channel);
        executorService.execute(() -> this.doUdpReceive(channel, message));
    }

    private void doUdpReceive(Object channel, EzyMessage message) {
        try {
            EzyNioHandlerGroup handlerGroup = (EzyNioHandlerGroup)this.handlerGroupManager.getHandlerGroup(channel);
            if (handlerGroup != null) {
                handlerGroup.fireMessageReceived(message);
            }
        }
        catch (Throwable e) {
            this.logger.info("I/O error at udp-message-received (channel: {})", channel, (Object)e);
        }
    }

    public void wsReceive(Session session, String message) {
        ExecutorService executorService = this.selectedExecutorService(session);
        executorService.execute(() -> this.doWsReceive(session, message));
    }

    public void wsReceive(Session session, byte[] payload, int offset, int len) {
        ExecutorService executorService = this.selectedExecutorService(session);
        executorService.execute(() -> this.doWsReceive(session, payload, offset, len));
    }

    private void doWsReceive(Session session, String message) {
        try {
            EzyWsHandlerGroup handlerGroup = (EzyWsHandlerGroup)this.handlerGroupManager.getHandlerGroup(session);
            if (handlerGroup != null) {
                handlerGroup.fireBytesReceived(message);
            }
        }
        catch (Throwable e) {
            this.logger.info("I/O error at ws-message-received (session: {})", (Object)session, (Object)e);
        }
    }

    private void doWsReceive(Session session, byte[] payload, int offset, int len) {
        try {
            EzyWsHandlerGroup handlerGroup = (EzyWsHandlerGroup)this.handlerGroupManager.getHandlerGroup(session);
            if (handlerGroup != null) {
                handlerGroup.fireBytesReceived(payload, offset, len);
            }
        }
        catch (Throwable e) {
            this.logger.info("I/O error at ws-message-received (session: {})", (Object)session, (Object)e);
        }
    }

    public void wsCloseConnection(Session session) {
        EzyWsHandlerGroup handlerGroup = (EzyWsHandlerGroup)this.handlerGroupManager.getHandlerGroup(session);
        if (handlerGroup != null) {
            handlerGroup.enqueueDisconnection();
        }
    }

    public void destroy() {
        for (ExecutorService executorService : this.executorServices) {
            executorService.shutdownNow();
        }
    }

    private ExecutorService selectedExecutorService(Object channel) {
        int index = Math.abs(channel.hashCode() % this.threadPoolSize);
        return this.executorServices[index];
    }

    protected int getMaxBufferSize() {
        return 4096;
    }

    public static class Builder
    implements EzyBuilder<EzySocketDataReceiver> {
        protected int threadPoolSize;
        protected EzyHandlerGroupManager handlerGroupManager;

        public Builder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder handlerGroupManager(EzyHandlerGroupManager handlerGroupManager) {
            this.handlerGroupManager = handlerGroupManager;
            return this;
        }

        public EzySocketDataReceiver build() {
            return new EzySocketDataReceiver(this);
        }
    }
}

