/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.callback.EzyCallback;
import com.tvd12.ezyfox.codec.EzyAbstractMessageDataDecoder;
import com.tvd12.ezyfox.codec.EzyByteToObjectDecoder;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageDataDecoder;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

public class EzySimpleMessageDataDecoder
extends EzyAbstractMessageDataDecoder<EzyByteToObjectDecoder>
implements EzyMessageDataDecoder {
    private final Queue<EzyMessage> queue = new LinkedList<EzyMessage>();

    public EzySimpleMessageDataDecoder(EzyByteToObjectDecoder decoder) {
        super(decoder);
    }

    @Override
    public Object decode(EzyMessage message, byte[] decryptionKey) throws Exception {
        return ((EzyByteToObjectDecoder)this.decoder).decode(message, decryptionKey);
    }

    @Override
    public void decode(byte[] bytes, EzyCallback<EzyMessage> callback) throws Exception {
        this.preDecode(bytes);
        ((EzyByteToObjectDecoder)this.decoder).decode(this.buffer, this.queue);
        this.handleQueue(callback);
        this.postDecode();
    }

    private void handleQueue(EzyCallback<EzyMessage> callback) throws Exception {
        while (this.queue.size() > 0 && this.active) {
            do {
                EzyMessage message = this.queue.poll();
                callback.call((Object)message);
            } while (this.queue.size() > 0);
            if (!this.buffer.hasRemaining()) continue;
            ((EzyByteToObjectDecoder)this.decoder).decode(this.buffer, this.queue);
        }
    }

    private void preDecode(byte[] bytes) {
        this.buffer = this.buffer == null ? this.newBuffer(bytes) : this.mergeBytes(bytes);
    }

    private void postDecode() {
        this.buffer = this.getRemainBytes(this.buffer);
    }

    private ByteBuffer newBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    private ByteBuffer mergeBytes(byte[] bytes) {
        int capacity = this.buffer.remaining() + bytes.length;
        ByteBuffer merge = ByteBuffer.allocate(capacity).put(this.buffer).put(bytes);
        merge.flip();
        return merge;
    }

    private ByteBuffer getRemainBytes(ByteBuffer old) {
        if (!old.hasRemaining()) {
            return null;
        }
        byte[] bytes = new byte[old.remaining()];
        old.get(bytes);
        return ByteBuffer.wrap(bytes);
    }

    public void reset() {
        this.queue.clear();
    }
}

