/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.MsgPackConstant;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyCastToByte;

public class MsgPackIntSerializer
implements EzyCastToByte {
    private static final MsgPackIntSerializer INSTANCE = new MsgPackIntSerializer();

    private MsgPackIntSerializer() {
    }

    public static MsgPackIntSerializer getInstance() {
        return INSTANCE;
    }

    public byte[] serialize(long value) {
        return value >= 0L ? this.parsePositive(value) : this.parseNegative(value);
    }

    private byte[] parsePositive(long value) {
        if (value <= MsgPackConstant.MAX_POSITIVE_FIXINT) {
            return this.parsePositiveFix(value);
        }
        if (value <= MsgPackConstant.MAX_UINT8) {
            return this.parseU8(value);
        }
        if (value <= MsgPackConstant.MAX_UINT16) {
            return this.parseU16(value);
        }
        if (value <= MsgPackConstant.MAX_UINT32) {
            return this.parseU32(value);
        }
        return this.parseU64(value);
    }

    private byte[] parsePositiveFix(long value) {
        return new byte[]{this.cast(value)};
    }

    private byte[] parseU8(long value) {
        return EzyBytes.getBytes((int)204, (long)value, (int)1);
    }

    private byte[] parseU16(long value) {
        return EzyBytes.getBytes((int)205, (long)value, (int)2);
    }

    private byte[] parseU32(long value) {
        return EzyBytes.getBytes((int)206, (long)value, (int)4);
    }

    private byte[] parseU64(long value) {
        return EzyBytes.getBytes((int)207, (long)value, (int)8);
    }

    private byte[] parseNegative(long value) {
        if (value >= MsgPackConstant.MIN_NEGATIVE_FIXINT) {
            return this.parseNegativeFix(value);
        }
        if (value >= MsgPackConstant.MIN_INT8) {
            return this.parse8(value);
        }
        if (value >= MsgPackConstant.MIN_INT16) {
            return this.parse16(value);
        }
        if (value >= MsgPackConstant.MIN_INT32) {
            return this.parse32(value);
        }
        return this.parse64(value);
    }

    private byte[] parseNegativeFix(long value) {
        return new byte[]{this.cast(0xE0L | value)};
    }

    private byte[] parse8(long value) {
        return EzyBytes.getBytes((int)208, (long)value, (int)1);
    }

    private byte[] parse16(long value) {
        return EzyBytes.getBytes((int)209, (long)value, (int)2);
    }

    private byte[] parse32(long value) {
        return EzyBytes.getBytes((int)210, (long)value, (int)4);
    }

    private byte[] parse64(long value) {
        return EzyBytes.getBytes((int)211, (long)value, (int)8);
    }
}

