/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller.api;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultMediaFilter;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;
import org.youngmonkeys.ezyplatform.request.UpdateMediaRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;
import org.youngmonkeys.ezyplatform.util.StringConverters;
import org.youngmonkeys.ezyplatform.web.annotation.UserId;
import org.youngmonkeys.ezyplatform.web.controller.service.WebMediaControllerService;
import org.youngmonkeys.ezyplatform.web.response.MediaDetailsResponse;

@Authenticated
public class WebApiMediaDetailsController {
    @EzyAutoBind
    protected WebMediaControllerService mediaControllerService;

    @Async
    @DoPost(value="/media/add")
    public void mediaAddPost(HttpServletRequest request, HttpServletResponse response, @UserId long userId, @RequestParam(value="avatar") boolean avatar, @RequestParam(value="notPublic") boolean notPublic) throws Exception {
        this.mediaControllerService.addMedia(request, response, userId, avatar, notPublic);
    }

    @DoPut(value="/media/{name}")
    public ResponseEntity mediaNamePut(@UserId long userId, @PathVariable String mediaName, @RequestBody UpdateMediaRequest request) {
        this.mediaControllerService.updateMedia(userId, mediaName, request);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/media/{name}")
    public ResponseEntity mediaNameDelete(@UserId long userId, @PathVariable String mediaName) {
        this.mediaControllerService.removeMedia(userId, mediaName, true);
        return ResponseEntity.noContent();
    }

    @DoGet(value="/media/{name}/details")
    public MediaDetailsResponse mediaNameDetailsGet(@UserId long userId, @PathVariable String name) throws Exception {
        return this.mediaControllerService.getMediaDetailsResponse(userId, name);
    }

    @DoGet(value="/media/list")
    public PaginationModel<MediaResponse> mediaListGet(@UserId long userId, @RequestParam(value="type") MediaType type, @RequestParam(value="keyword") String keyword, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        return this.mediaControllerService.getMediaList((MediaFilter)DefaultMediaFilter.builder().type(type).prefixKeyword(StringConverters.trimOrNull((String)keyword)).ownerUserId(Long.valueOf(userId)).build(), nextPageToken, prevPageToken, lastPage, limit);
    }

    @Generated
    public void setMediaControllerService(WebMediaControllerService mediaControllerService) {
        this.mediaControllerService = mediaControllerService;
    }
}

