/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.time.LocalDateTime;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Letter;
import org.youngmonkeys.ezyplatform.entity.LetterReceiver;
import org.youngmonkeys.ezyplatform.entity.LetterStatus;
import org.youngmonkeys.ezyplatform.entity.NotificationReceiver;
import org.youngmonkeys.ezyplatform.entity.NotificationStatus;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.model.LetterModel;
import org.youngmonkeys.ezyplatform.repo.LetterReceiverRepository;
import org.youngmonkeys.ezyplatform.repo.LetterRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.service.DefaultLetterService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.web.converter.WebEntityToModelConverter;
import org.youngmonkeys.ezyplatform.web.converter.WebModelToEntityConverter;
import org.youngmonkeys.ezyplatform.web.repo.WebLetterReceiverRepository;
import org.youngmonkeys.ezyplatform.web.repo.WebLetterRepository;
import org.youngmonkeys.ezyplatform.web.repo.WebNotificationReceiverRepository;

@Service
public class WebLetterService
extends DefaultLetterService {
    private final ClockProxy clock;
    private final WebLetterRepository letterRepository;
    private final WebLetterReceiverRepository letterReceiverRepository;
    private final WebNotificationReceiverRepository notificationReceiverRepository;
    private final WebEntityToModelConverter entityToModelConverter;

    public WebLetterService(ClockProxy clock, WebLetterRepository letterRepository, WebLetterReceiverRepository letterReceiverRepository, WebNotificationReceiverRepository notificationReceiverRepository, WebEntityToModelConverter entityToModelConverter, WebModelToEntityConverter modelToEntityConverter) {
        super((LetterRepository)letterRepository, (LetterReceiverRepository)letterReceiverRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultModelToEntityConverter)modelToEntityConverter);
        this.clock = clock;
        this.letterRepository = letterRepository;
        this.letterReceiverRepository = letterReceiverRepository;
        this.notificationReceiverRepository = notificationReceiverRepository;
        this.entityToModelConverter = entityToModelConverter;
    }

    public void updateUserLetterByReceive(long userId, long letterId) {
        this.updateUserLetterByReceive(userId, letterId, true);
    }

    public void updateUserLetterByReceive(long userId, long letterId, boolean throwExceptionIfNotExists) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToUserId(letterId, userId);
        if (letterReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("letter");
            }
            return;
        }
        if (letterReceiver.getReceivedAt() == null) {
            letterReceiver.setReceivedAt(this.clock.nowDateTime());
            letterReceiver.setStatus(LetterStatus.RECEIVED.toString());
            this.letterReceiverRepository.save(letterReceiver);
        }
    }

    public void updateUserLettersByReceive(long userId, Collection<Long> letterIds) {
        Reactive.multiple().registerConsumers(letterIds, it -> this.updateUserLetterByRead(userId, (long)it, false)).blockingExecute();
    }

    public void updateUserLetterByRead(long userId, long letterId) {
        this.updateUserLetterByRead(userId, letterId, true);
    }

    public void updateUserLetterByRead(long userId, long letterId, boolean throwExceptionIfNotExists) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToUserId(letterId, userId);
        if (letterReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("letter");
            }
            return;
        }
        if (letterReceiver.getReadAt() == null) {
            NotificationReceiver notificationReceiver;
            LocalDateTime now = this.clock.nowDateTime();
            if (letterReceiver.getReceivedAt() == null) {
                letterReceiver.setReceivedAt(now);
            }
            letterReceiver.setReadAt(now);
            letterReceiver.setStatus(LetterStatus.READ.toString());
            this.letterReceiverRepository.save(letterReceiver);
            long notificationReceiverId = letterReceiver.getNotificationReceiverId();
            if (notificationReceiverId > 0L && (notificationReceiver = (NotificationReceiver)this.notificationReceiverRepository.findById(notificationReceiverId)) != null && notificationReceiver.getReadAt() == null) {
                notificationReceiver.setReadAt(now);
                notificationReceiver.setStatus(NotificationStatus.READ.toString());
                this.notificationReceiverRepository.save(notificationReceiver);
            }
        }
    }

    public void updateUserLettersByRead(long userId, Collection<Long> letterIds) {
        Reactive.multiple().registerConsumers(letterIds, it -> this.updateUserLetterByRead(userId, (long)it, false)).blockingExecute();
    }

    public void deleteUserLetter(long userId, long letterId) {
        this.deleteUserLetter(userId, letterId, true);
    }

    public void deleteUserLetter(long userId, long letterId, boolean throwExceptionIfNotExists) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToUserId(letterId, userId);
        if (letterReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("letter");
            }
            return;
        }
        this.letterReceiverRepository.delete(letterReceiver.getId());
    }

    public void deleteUserLetters(long userId, Collection<Long> letterIds) {
        Reactive.multiple().registerConsumers(letterIds, it -> this.deleteUserLetter(userId, (long)it, false)).blockingExecute();
    }

    public LetterModel getUserLetter(long userId, long letterId) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToUserId(letterId, userId);
        if (letterReceiver == null) {
            return null;
        }
        Letter letter = (Letter)this.letterRepository.findById(letterId);
        if (letter == null) {
            return null;
        }
        return this.entityToModelConverter.toModel(letter, letterReceiver);
    }

    public long countUserUnreadLetters(long userId) {
        return this.letterReceiverRepository.countUnreadLettersByToUserId(userId);
    }
}

