/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.view;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.server.core.view.View;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import com.tvd12.ezyhttp.server.core.view.ViewDecorator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.web.manager.WebEnvironmentManager;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;

@EzySingleton
public class WebFinalViewDecorator
implements ViewDecorator {
    private final WebEnvironmentManager environmentManager;
    private final WebSettingService settingService;
    private final EzyLazyInitializer<ViewContext> viewContext;

    public WebFinalViewDecorator(WebEnvironmentManager environmentManager, WebSettingService settingService, EzySingletonFactory singletonFactory) {
        this.environmentManager = environmentManager;
        this.settingService = settingService;
        this.viewContext = new EzyLazyInitializer(() -> (ViewContext)singletonFactory.getSingletonCast(ViewContext.class));
    }

    public void decorate(HttpServletRequest request, View view) {
        this.setCommonVariables(view);
        this.setDateTimeFormatVariables(view);
        this.setAdditionalVariables(view);
    }

    private void setCommonVariables(View view) {
        view.setVariableIfAbsent("ezyResourceVersion", (Object)this.environmentManager.getServerStartTime());
    }

    private void setDateTimeFormatVariables(View view) {
        view.setVariableIfAbsent("defaultDateFormat", this.settingService::getWebDateFormat);
        view.setVariableIfAbsent("defaultTimeFormat", this.settingService::getWebTimeFormat);
        view.setVariableIfAbsent("defaultDateTimeFormat", this.settingService::getWebDateTimeFormat);
        view.setVariableIfAbsent("defaultDateMinuteFormat", this.settingService::getWebDateMinuteFormat);
    }

    public void setAdditionalVariables(View view) {
        Reactive.Multiple multiple = Reactive.multiple().register((Object)"web_additional_head", () -> this.settingService.getTextValue("web_additional_head")).register((Object)"web_additional_style_files", () -> this.settingService.getListStringValue("web_additional_style_files")).register((Object)"web_additional_style", () -> this.settingService.getTextValue("web_additional_style")).register((Object)"web_additional_script_files", () -> this.settingService.getListStringValue("web_additional_script_files")).register((Object)"web_additional_script", () -> this.settingService.getTextValue("web_additional_script")).register((Object)"web_additional_foot", () -> this.settingService.getTextValue("web_additional_foot"));
        if (!view.containsVariable("websocketUrl")) {
            multiple.register((Object)"websocketUrl", () -> ((WebSettingService)this.settingService).getWebsocketUrl());
        }
        if (!view.containsVariable("siteName")) {
            multiple.register((Object)"siteName", () -> this.settingService.getTextValue("web_site_name"));
        }
        if (!view.containsVariable("siteTitle")) {
            multiple.register((Object)"siteTitle", () -> this.settingService.getTextValue("web_site_title"));
        }
        if (!view.containsVariable("siteIconUrl")) {
            multiple.register((Object)"siteIconUrl", () -> this.settingService.getTextValue("web_site_icon_url", "/images/favicon.ico"));
        }
        if (!view.containsVariable("siteLogoUrl")) {
            multiple.register((Object)"siteLogoUrl", () -> this.settingService.getTextValue("web_site_logo_url"));
        }
        if (!view.containsVariable("pageDescription")) {
            multiple.register((Object)"pageDescription", () -> this.settingService.getTextValue("web_site_tagline"));
        }
        if (!view.containsVariable("pageImageUrl")) {
            multiple.register((Object)"pageImageUrl", () -> this.settingService.getTextValue("web_site_image_url"));
        }
        if (!view.containsVariable("pageTitleSeparator")) {
            multiple.register((Object)"pageTitleSeparator", () -> this.settingService.getTextValue("web_page_title_separator"));
        }
        multiple.blockingConsume(it -> {
            String pageTitleSeparator;
            String pageImageUrl;
            String pageDescription;
            String siteLogoUrl;
            String siteIconUrl;
            String siteTitle;
            String siteName;
            String websocketUrl;
            String additionalFoot;
            String additionalHead = (String)it.get((Object)"web_additional_head");
            if (EzyStrings.isNotBlank((String)additionalHead)) {
                view.appendToVariable("additionalHeads", (Object)additionalHead);
            }
            List additionalStyleFiles = (List)it.get((Object)"web_additional_style_files");
            view.appendValuesToVariable("additionalStyleFiles", (Collection)additionalStyleFiles);
            String additionalStyle = (String)it.get((Object)"web_additional_style");
            if (EzyStrings.isNotBlank((String)additionalStyle)) {
                view.appendToVariable("additionalStyles", (Object)additionalStyle);
            }
            List additionalScriptFiles = (List)it.get((Object)"web_additional_script_files");
            view.appendValuesToVariable("additionalScriptFiles", (Collection)additionalScriptFiles);
            String additionalScript = (String)it.get((Object)"web_additional_script");
            if (EzyStrings.isNotBlank((String)additionalScript)) {
                view.appendToVariable("additionalScripts", (Object)additionalScript);
            }
            if (EzyStrings.isNotBlank((String)(additionalFoot = (String)it.get((Object)"web_additional_foot")))) {
                view.appendToVariable("additionalFoots", (Object)additionalFoot);
            }
            if (EzyStrings.isNotBlank((String)(websocketUrl = (String)it.get((Object)"websocketUrl")))) {
                view.setVariable("websocketUrl", (Object)websocketUrl);
            }
            if (EzyStrings.isNotBlank((String)(siteName = (String)it.get((Object)"siteName")))) {
                view.setVariable("siteName", (Object)siteName);
            }
            if (EzyStrings.isNotBlank((String)(siteTitle = (String)it.get((Object)"siteTitle")))) {
                view.setVariable("siteTitle", (Object)siteTitle);
            }
            if (EzyStrings.isNotBlank((String)(siteIconUrl = (String)it.get((Object)"siteIconUrl")))) {
                view.setVariable("siteIconUrl", (Object)siteIconUrl);
            }
            if (EzyStrings.isNotBlank((String)(siteLogoUrl = (String)it.get((Object)"siteLogoUrl")))) {
                view.setVariable("siteLogoUrl", (Object)siteLogoUrl);
            }
            if (EzyStrings.isNotBlank((String)(pageDescription = (String)it.get((Object)"pageDescription")))) {
                view.setVariable("pageDescription", (Object)pageDescription);
            }
            if (EzyStrings.isNotBlank((String)(pageImageUrl = (String)it.get((Object)"pageImageUrl")))) {
                view.setVariable("pageImageUrl", (Object)pageImageUrl);
            }
            if ((pageTitleSeparator = (String)it.get((Object)"pageTitleSeparator")) != null) {
                view.setVariable("pageTitleSeparator", (Object)pageTitleSeparator);
            }
        });
        view.setVariableIfAbsent("pageTitleSeparator", (Object)"-");
        view.setVariableIfAbsent("additionalValueMap", new HashMap());
        view.setVariableIfAbsent("additionalMessageMap", new HashMap());
        Collection keysFromView = (Collection)view.getVariable("additionalMessageKeys");
        if (keysFromView != null) {
            ViewContext viewContext = (ViewContext)this.viewContext.get();
            view.putKeyValuesToVariable("additionalMessageMap", viewContext.resolveMessages(view.getLocale(), keysFromView));
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

