/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.gamebox.entity.MMORoom;
import com.tvd12.gamebox.entity.MMORoomGroup;
import com.tvd12.gamebox.exception.MaxRoomException;
import java.util.Arrays;

public class MMOVirtualWorld
extends EzyLoggable {
    private final MMORoomGroup[] roomGroups;
    private final int roomGroupCount;
    private final int timeTickMillis;
    private final int maxRoomCount;

    protected MMOVirtualWorld(Builder builder) {
        this.roomGroupCount = builder.roomGroupCount;
        this.timeTickMillis = builder.timeTickMillis;
        this.maxRoomCount = builder.maxRoomCount;
        this.roomGroups = this.createRoomGroups();
    }

    public static Builder builder() {
        return new Builder();
    }

    private MMORoomGroup[] createRoomGroups() {
        MMORoomGroup[] groups = new MMORoomGroup[this.roomGroupCount];
        for (int i = 0; i < this.roomGroupCount; ++i) {
            groups[i] = MMORoomGroup.builder().timeTickMillis(this.timeTickMillis).build();
        }
        return groups;
    }

    private MMORoomGroup getRoomGroupByRoomId(long roomId) {
        int roomGroupIndex = (int)(roomId % (long)this.roomGroupCount);
        return this.roomGroups[roomGroupIndex];
    }

    public void addRoom(MMORoom room) {
        if (this.getRoomCount() >= this.maxRoomCount) {
            throw new MaxRoomException(room.toString(), this.getRoomCount(), this.maxRoomCount);
        }
        MMORoomGroup group = this.getRoomGroupByRoomId(room.getId());
        group.addRoom(room);
    }

    public void removeRoom(MMORoom room) {
        MMORoomGroup group = this.getRoomGroupByRoomId(room.getId());
        group.removeRoom(room);
    }

    public MMORoom getRoom(long roomId) {
        MMORoomGroup group = this.getRoomGroupByRoomId(roomId);
        return group.getRoom(roomId);
    }

    public int getRoomCount() {
        return Arrays.stream(this.roomGroups).map(MMORoomGroup::getRoomCount).reduce(0, Integer::sum);
    }

    public static class Builder
    implements EzyBuilder<MMOVirtualWorld> {
        private int timeTickMillis = 100;
        private int roomGroupCount = 2 * Runtime.getRuntime().availableProcessors();
        private int maxRoomCount = 10000;

        public Builder maxRoomCount(int maxRoomCount) {
            this.maxRoomCount = maxRoomCount;
            return this;
        }

        public Builder roomGroupCount(int roomGroupCount) {
            this.roomGroupCount = roomGroupCount;
            return this;
        }

        public Builder timeTickMillis(int timeTickMillis) {
            this.timeTickMillis = timeTickMillis;
            return this;
        }

        public MMOVirtualWorld build() {
            return new MMOVirtualWorld(this);
        }
    }
}

