/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.gamebox.entity.Player;
import com.tvd12.gamebox.entity.Room;
import com.tvd12.gamebox.manager.DefaultPlayerManager;
import com.tvd12.gamebox.manager.PlayerManager;

public class NormalRoom
extends Room {
    protected final PlayerManager playerManager;

    public NormalRoom(Builder<?> builder) {
        super(builder);
        this.playerManager = builder.playerManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addPlayer(Player player) {
        player.setCurrentRoomId(this.id);
        this.playerManager.addPlayer(player);
    }

    public void removePlayer(Player player) {
        this.playerManager.removePlayer(player.getName());
    }

    public <T extends PlayerManager> T getPlayerManager() {
        return (T)this.playerManager;
    }

    public static class Builder<B extends Builder<B>>
    extends Room.Builder<B> {
        protected PlayerManager playerManager;

        public B playerManager(PlayerManager playerManager) {
            this.playerManager = playerManager;
            return (B)this;
        }

        public B defaultPlayerManager(int maxPlayer) {
            this.playerManager = new DefaultPlayerManager(maxPlayer);
            return (B)this;
        }

        @Override
        protected void preBuild() {
            if (this.playerManager == null) {
                this.playerManager = new DefaultPlayerManager(999);
            }
        }

        @Override
        public NormalRoom build() {
            return (NormalRoom)super.build();
        }

        @Override
        protected NormalRoom newProduct() {
            return new NormalRoom(this);
        }
    }
}

