/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.bean.impl;

import com.tvd12.ezyfox.bean.annotation.EzyPrototype;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;

public final class EzyBeanNameParser {
    private EzyBeanNameParser() {
    }

    public static String getBeanName(Class<?> clazz) {
        if (clazz.isAnnotationPresent(EzySingleton.class)) {
            return EzyBeanNameParser.getSingletonName(clazz);
        }
        if (clazz.isAnnotationPresent(EzyPrototype.class)) {
            return EzyBeanNameParser.getPrototypeName(clazz);
        }
        return EzyClasses.getVariableName(clazz);
    }

    public static String getSingletonName(EzyField field) {
        return EzyBeanNameParser.getSingletonName((EzySingleton)field.getAnnotation(EzySingleton.class), field.getName());
    }

    public static String getSingletonName(EzyMethod method) {
        return EzyBeanNameParser.getSingletonName((EzySingleton)method.getAnnotation(EzySingleton.class), method.getFieldName());
    }

    public static String getSingletonName(Class<?> clazz) {
        return EzyBeanNameParser.getSingletonName(clazz, clazz.getAnnotation(EzySingleton.class));
    }

    public static String getSingletonName(Class<?> clazz, EzySingleton annotation) {
        return EzyBeanNameParser.getSingletonName(annotation, EzyClasses.getVariableName(clazz, (String)"Impl"));
    }

    public static String getSingletonName(EzySingleton annotation, String defaultName) {
        if (annotation == null) {
            return defaultName;
        }
        String value = annotation.value();
        if (EzyStrings.isNoContent((String)value)) {
            return defaultName;
        }
        return value;
    }

    public static String getPrototypeName(EzyField field) {
        return EzyBeanNameParser.getPrototypeName((EzyPrototype)field.getAnnotation(EzyPrototype.class), field.getName());
    }

    public static String getPrototypeName(EzyMethod method) {
        return EzyBeanNameParser.getPrototypeName((EzyPrototype)method.getAnnotation(EzyPrototype.class), method.getFieldName());
    }

    public static String getPrototypeName(Class<?> clazz) {
        return EzyBeanNameParser.getPrototypeName(clazz, clazz.getAnnotation(EzyPrototype.class));
    }

    public static String getPrototypeName(Class<?> clazz, EzyPrototype annotation) {
        return EzyBeanNameParser.getPrototypeName(annotation, EzyClasses.getVariableName(clazz, (String)"Impl"));
    }

    public static String getPrototypeName(EzyPrototype annotation, String defaultName) {
        if (annotation == null) {
            return defaultName;
        }
        String value = annotation.value();
        if (EzyStrings.isNoContent((String)value)) {
            return defaultName;
        }
        return value;
    }
}

