/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyStrings;
import java.time.LocalDateTime;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataAppender;
import org.youngmonkeys.ezyplatform.admin.repo.AdminLinkRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.entity.Link;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

public abstract class AdminLinkAppender<V, P>
extends AdminDataAppender<V, Link, P> {
    private final ClockProxy clock;
    private final AdminLinkRepository linkRepository;

    public AdminLinkAppender(ClockProxy clock, ObjectMapper objectMapper, AdminSettingService settingService, AdminLinkRepository linkRepository) {
        super(objectMapper, settingService);
        this.clock = clock;
        this.linkRepository = linkRepository;
    }

    @Override
    protected Link toDataRecord(V value) {
        return this.toLink(value);
    }

    protected abstract Link toLink(V var1);

    @Override
    protected void addDataRecord(Link link) {
        if (EzyStrings.isBlank((String)link.getLinkType()) || EzyStrings.isBlank((String)link.getLinkUri())) {
            return;
        }
        Link entity = (Link)this.linkRepository.findByField("linkUri", link.getLinkUri());
        LocalDateTime now = this.clock.nowDateTime();
        if (entity == null) {
            entity = link;
            entity.setCreatedAt(now);
            entity.setUpdatedAt(now);
        } else {
            entity.setLinkType(link.getLinkType());
            entity.setLinkUri(link.getLinkUri());
            entity.setDescription(link.getDescription());
            entity.setImageId(link.getImageId());
            entity.setSourceType(link.getSourceType());
            entity.setSourceId(link.getSourceId());
            entity.setUpdatedAt(now);
        }
        if (entity.getSourceType() == null) {
            entity.setSourceType("UNKNOWN");
        }
        this.linkRepository.save(entity);
        this.logger.info("append link {}: {}", (Object)link.getLinkType(), (Object)link.getLinkUri());
    }
}

