/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.EzyPackagesToScanProvider;
import com.tvd12.ezyhttp.core.json.ObjectMapperBuilder;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.data.ModuleMetadata;
import org.youngmonkeys.ezyplatform.admin.io.AdminModuleMetadataInteractor;
import org.youngmonkeys.ezyplatform.admin.io.AdminModulePropertiesReader;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;

public class AdminPackagesToScanProvider
implements EzyPackagesToScanProvider {
    private final AdminModulePropertiesReader modulePropertiesReader = new AdminModulePropertiesReader();
    private final AdminModuleMetadataInteractor moduleMetadataInteractor = new AdminModuleMetadataInteractor(new ObjectMapperBuilder().build());
    private static final String FOLDER_PLUGINS = "admin/plugins";

    public Set<String> provide() {
        String ezyplatformHome = FileSystemManager.readConfigAndGetEzyHomePathString();
        Map<String, ModuleMetadata> moduleMetadataMap = this.moduleMetadataInteractor.readAdminPluginMetadataMap(ezyplatformHome);
        HashSet<String> answer = new HashSet<String>();
        List pluginFolders = FileSystemManager.getModuleFolders((String)ezyplatformHome, (String)FOLDER_PLUGINS);
        for (File pluginFolder : pluginFolders) {
            ModuleMetadata moduleMetadata = moduleMetadataMap.get(pluginFolder.getName());
            if (moduleMetadata == null || !moduleMetadata.isActive()) continue;
            Module moduleProperties = this.modulePropertiesReader.read(ModuleType.ADMIN_PLUGIN, pluginFolder);
            answer.add(moduleProperties.getPackageName());
        }
        return answer;
    }
}

