/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.AdminLetterResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminLetterService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.model.LetterReceiverModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.SimpleLetterModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;

@EzySingleton
public class AdminLetterModelDecorator {
    private final AdminAdminService adminService;
    private final AdminLetterService letterService;
    private final AdminUserService userService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public PaginationModel<AdminLetterResponse> decorate(PaginationModel<LetterReceiverModel> pagination) {
        List models = pagination.getItems();
        Set letterIds = models.stream().map(LetterReceiverModel::getLetterId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map letterById = this.letterService.getLetterMapByIds(letterIds);
        Set fromAdminIds = letterById.values().stream().map(SimpleLetterModel::getFromAdminId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map fromAdminById = this.adminService.getAdminNameMapByIds(fromAdminIds);
        Set fromUserIds = letterById.values().stream().map(SimpleLetterModel::getFromUserId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map fromUserById = this.userService.getUsernameMapByIds(fromUserIds);
        return pagination.map(it -> {
            SimpleLetterModel letter = letterById.getOrDefault(it.getLetterId(), SimpleLetterModel.builder().build());
            return this.modelToResponseConverter.toResponse(letter, (LetterReceiverModel)it, (AdminNameModel)fromAdminById.get(letter.getFromAdminId()), (UserNameModel)fromUserById.get(letter.getFromUserId()));
        });
    }

    @Generated
    public AdminLetterModelDecorator(AdminAdminService adminService, AdminLetterService letterService, AdminUserService userService, AdminModelToResponseConverter modelToResponseConverter) {
        this.adminService = adminService;
        this.letterService = letterService;
        this.userService = userService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

