/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import com.tvd12.ezyhttp.server.core.view.View;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminResetPasswordValidator;
import org.youngmonkeys.ezyplatform.util.HttpRequests;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

@Controller
public class AdminResetPasswordController {
    private final AdminAdminService adminService;
    private final AdminResetPasswordValidator resetPasswordValidator;

    @DoGet(value="/admins/{username}/reset-password")
    public View adminsUsernameResetPasswordGet(HttpServletRequest request, RequestArguments arguments, @PathVariable String username, @RequestParam(value="token") String token, @RequestParam(value="tokenExpiredAt") long tokenExpiredAt) {
        this.resetPasswordValidator.validate(username, token, tokenExpiredAt);
        String lang = HttpRequests.getLanguage((HttpServletRequest)request);
        Map errors = (Map)arguments.getRedirectionAttribute("errors");
        return View.builder().template("admins/reset-password").addVariable("errors", (Object)errors).addVariable("ezyLang", (Object)lang).addVariable("resetPasswordAdminUsername", (Object)username).addVariable("resetPasswordToken", (Object)token).addVariable("resetPasswordTokenExpiredAt", (Object)tokenExpiredAt).build();
    }

    @DoPost(value="/admins/{username}/reset-password")
    public Redirect adminsUsernameResetPasswordPost(HttpServletRequest request, @PathVariable String username, @RequestParam(value="token") String token, @RequestParam(value="tokenExpiredAt") long tokenExpiredAt, @RequestParam(value="password") String newPassword) {
        long adminId = this.resetPasswordValidator.validate(username, token, tokenExpiredAt);
        if (DefaultValidator.isValidPassword((String)newPassword)) {
            this.adminService.setNewPassword(adminId, newPassword);
            return Redirect.builder().uri(HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/login")).build();
        }
        return Redirect.builder().uri(request.getRequestURI() + "?" + request.getQueryString()).addAttribute("errors", Collections.singletonMap("password", "invalid")).build();
    }

    @Generated
    public AdminResetPasswordController(AdminAdminService adminService, AdminResetPasswordValidator resetPasswordValidator) {
        this.adminService = adminService;
        this.resetPasswordValidator = resetPasswordValidator;
    }
}

