/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.converter;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyLists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.data.Menu;
import org.youngmonkeys.ezyplatform.admin.data.MenuItem;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.model.AdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.model.SettingModel;
import org.youngmonkeys.ezyplatform.admin.response.AddAdminResponse;
import org.youngmonkeys.ezyplatform.admin.response.AddUserResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminInfoResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminLetterResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminMediaDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminNameResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminNotificationResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminRoleResponse;
import org.youngmonkeys.ezyplatform.admin.response.MenuItemResponse;
import org.youngmonkeys.ezyplatform.admin.response.MenuResponse;
import org.youngmonkeys.ezyplatform.admin.response.ModuleDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.response.SettingResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserRoleResponse;
import org.youngmonkeys.ezyplatform.converter.HttpModelToResponseConverter;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.model.AdminRoleModel;
import org.youngmonkeys.ezyplatform.model.LetterReceiverModel;
import org.youngmonkeys.ezyplatform.model.MediaDetailsModel;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.NotificationReceiverModel;
import org.youngmonkeys.ezyplatform.model.SimpleLetterModel;
import org.youngmonkeys.ezyplatform.model.SimpleNotificationModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;
import org.youngmonkeys.ezyplatform.model.UserRoleModel;
import org.youngmonkeys.ezyplatform.model.UserRoleNameModel;

@EzySingleton
public class AdminModelToResponseConverter
extends HttpModelToResponseConverter {
    public ModuleDetailsResponse toResponse(Module module, boolean containsSqlScripts, Menu menu, String description, String settings, Long updatedAt, AdminModel updatedBy) {
        return ModuleDetailsResponse.builder().typeName(module.getTypeName()).name(module.getName()).packageName(module.getPackageName()).version(module.getVersion()).projectName(module.getProjectName()).authorName(module.getAuthorName()).authorUrl(module.getAuthorUrl()).description(description).containsSqlScripts(containsSqlScripts).settings(settings).zoneName(module.getZoneName()).priority(module.getPriority()).entryLoader(module.getEntryLoader()).configFile(module.getConfigFile()).listenEvents(module.getListenEvents()).menu(this.toResponse(menu)).active(module.isActive()).dependencies(module.getDependencies()).updatedBy(this.toNameResponse(updatedBy)).lastUpdated(updatedAt != null ? updatedAt.longValue() : module.getLastUpdated()).build();
    }

    public MenuResponse toResponse(Menu model) {
        if (model == null) {
            return null;
        }
        return MenuResponse.builder().name(model.getName()).url(model.getUri()).menuItems(model.getItems().stream().filter(MenuItem::isVisible).map(this::toResponse).collect(Collectors.toList())).build();
    }

    public MenuItemResponse toResponse(MenuItem model) {
        return MenuItemResponse.builder().name(model.getName()).url(model.getUri()).build();
    }

    public SettingResponse toResponse(SettingModel model) {
        return SettingResponse.builder().id(model.getId()).name(model.getName()).value(model.getDataType() == DataType.PASSWORD ? "************" : model.getValue()).dataType(model.getDataType()).dataTypeName(model.getDataType().getName()).createdAt(model.getCreatedAt()).updatedAt(model.getUpdatedAt()).build();
    }

    public AdminInfoResponse toResponse(AdminModel model, MediaNameModel avatar) {
        return AdminInfoResponse.builder().id(model.getId()).uuid(model.getUuid()).username(model.getUsername()).avatar(avatar).email(model.getEmail()).phone(model.getPhone()).url(model.getUrl()).displayName(model.getDisplayName()).status(model.getStatus()).createdAt(model.getCreatedAt()).updatedAt(model.getCreatedAt()).build();
    }

    public UserResponse toResponse(UserModel model, MediaNameModel avatar) {
        return UserResponse.builder().id(model.getId()).username(model.getUsername()).displayName(model.getDisplayName()).avatar(avatar).email(model.getEmail()).phone(model.getPhone()).url(model.getUrl()).avatarImageId(model.getAvatarImageId()).coverImageId(model.getCoverImageId()).status(model.getStatus()).createdAt(model.getCreatedAt()).updatedAt(model.getUpdatedAt()).build();
    }

    public AdminMediaDetailsResponse toResponse(MediaDetailsModel model, AdminNameModel ownerAdmin, UserNameModel ownerUser, BigDecimal durationInMinutes) {
        return AdminMediaDetailsResponse.builder().size(model.getSize()).width(model.getWidth()).height(model.getHeight()).id(model.getId()).name(model.getName()).originalName(model.getOriginalName()).url(model.getUrl()).uploadFrom(model.getUploadFrom()).type(model.getType()).mimeType(model.getMimeType()).ownerAdmin(ownerAdmin).ownerUser(ownerUser).title(model.getTitle()).caption(model.getCaption()).alternativeText(model.getAlternativeText()).description(model.getDescription()).durationInMinutes(durationInMinutes).publicMedia(model.isPublicMedia()).createdAt(model.getCreatedAt()).build();
    }

    public AdminLetterResponse toResponse(SimpleLetterModel letter, LetterReceiverModel letterReceiver, AdminNameModel fromAdmin, UserNameModel fromUser) {
        return AdminLetterResponse.builder().id(letter.getId()).type(letter.getType()).title(letter.getTitle()).content(letter.getContent()).contentType(letter.getContentType()).fromAdmin(fromAdmin).fromUser(fromUser).status(letter.getStatus()).parentId(letter.getParentId()).letterReceiverId(letterReceiver.getId()).notificationReceiverId(letterReceiver.getNotificationReceiverId()).confidenceLevel(letterReceiver.getConfidenceLevel()).importantLevel(letterReceiver.getImportantLevel()).receiveStatus(letterReceiver.getStatus()).sentAt(letterReceiver.getSentAt()).receivedAt(letterReceiver.getReceivedAt()).readAt(letterReceiver.getReadAt()).build();
    }

    public AdminNotificationResponse toResponse(SimpleNotificationModel notification, NotificationReceiverModel notificationReceiver) {
        return AdminNotificationResponse.builder().id(notification.getId()).type(notification.getType()).title(notification.getTitle()).content(notification.getContent()).contentType(notification.getContentType()).iconImage(notification.getIconImage()).deepLink(notification.getDeepLink()).fromAdminId(notification.getFromAdminId()).fromUserId(notification.getFromUserId()).status(notification.getStatus()).toAdminId(notificationReceiver.getToAdminId()).toUserId(notificationReceiver.getToUserId()).notificationReceiverId(notificationReceiver.getId()).confidenceLevel(notificationReceiver.getConfidenceLevel()).importantLevel(notificationReceiver.getImportantLevel()).receiveStatus(notificationReceiver.getStatus()).sentAt(notificationReceiver.getSentAt()).receivedAt(notificationReceiver.getReceivedAt()).readAt(notificationReceiver.getReadAt()).build();
    }

    public AddAdminResponse toAddResponse(AdminModel model) {
        return AddAdminResponse.builder().adminId(model.getId()).username(model.getUsername()).build();
    }

    public AddUserResponse toAddResponse(UserModel model) {
        return AddUserResponse.builder().userId(model.getId()).username(model.getUsername()).build();
    }

    public AdminNameResponse toNameResponse(AdminModel model) {
        if (model == null) {
            return null;
        }
        return AdminNameResponse.builder().username(model.getUsername()).displayName(model.getDisplayName()).build();
    }

    public List<AdminRoleResponse> toAdminRoleResponses(List<AdminRoleNameModel> roleNames, Map<Long, Long> adminCounts) {
        return EzyLists.newArrayList(roleNames, it -> AdminRoleResponse.builder().name(it.getName()).displayName(it.getDisplayName()).priority(it.getPriority()).admins(adminCounts.getOrDefault(it.getId(), 0L)).createdAt(it.getCreatedAt()).build());
    }

    public AdminRoleMemberResponse toAdminRoleMemberResponse(AdminModel admin, AdminRoleModel adminRole) {
        return AdminRoleMemberResponse.builder().memberName(AdminNameModel.fromAdminModel((AdminModel)admin)).roleGrantedAt(adminRole != null ? adminRole.getCreatedAt() : System.currentTimeMillis()).build();
    }

    public List<UserRoleResponse> toUserRoleResponses(List<UserRoleNameModel> roleNames) {
        return EzyLists.newArrayList(roleNames, it -> UserRoleResponse.builder().name(it.getName()).displayName(it.getDisplayName()).priority(it.getPriority()).createdAt(it.getCreatedAt()).build());
    }

    public UserRoleMemberResponse toUserRoleMemberResponse(UserModel user, UserRoleModel userRole) {
        return UserRoleMemberResponse.builder().memberName(UserNameModel.fromUserModel((UserModel)user)).roleGrantedAt(userRole != null ? userRole.getCreatedAt() : System.currentTimeMillis()).build();
    }
}

