/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.io;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.properties.file.mapping.PropertiesMapper;
import java.io.File;
import java.nio.file.Paths;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.entity.ModuleType;

@EzySingleton
public class AdminModulePropertiesReader {
    public Module read(File moduleFolder) {
        File modulePropertiesFile = this.getModulePropertiesFile(moduleFolder);
        Module module = modulePropertiesFile.exists() ? (Module)new PropertiesMapper().file(modulePropertiesFile.toString()).map(Module.class) : new Module();
        module.setName(moduleFolder.getName());
        if (EzyStrings.isBlank((String)module.getProjectName())) {
            module.setProjectName(EzyStrings.toDisplayName((String)moduleFolder.getName()));
        }
        module.setLastUpdated(moduleFolder.lastModified());
        return module;
    }

    public Module read(ModuleType moduleType, File moduleFolder) {
        Module module = this.read(moduleFolder);
        module.setType(moduleType);
        module.setTypeName(moduleType.getName());
        return module;
    }

    private File getModulePropertiesFile(File moduleFolder) {
        return Paths.get(moduleFolder.toString(), "module.properties").toFile();
    }
}

