/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminRoleModel;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.model.AdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateAdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.repo.AdminRoleNameRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminRoleRepository;
import org.youngmonkeys.ezyplatform.admin.result.RoleAdminCountResult;
import org.youngmonkeys.ezyplatform.entity.AdminRole;
import org.youngmonkeys.ezyplatform.entity.AdminRoleId;
import org.youngmonkeys.ezyplatform.entity.AdminRoleName;
import org.youngmonkeys.ezyplatform.model.AdminRoleModel;
import org.youngmonkeys.ezyplatform.repo.AdminIdRoleRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.rx.RxValueMap;
import org.youngmonkeys.ezyplatform.service.DefaultAdminRoleService;

@Service
public class AdminAdminRoleService
extends DefaultAdminRoleService {
    private final AdminRoleRepository adminRoleRepository;
    private final AdminRoleNameRepository adminRoleNameRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;
    private final AdminEntityToModelConverter entityToModelConverter;
    private final AtomicReference<Long> superAdminRoleIdRef;
    private final AtomicReference<Set<Long>> specialAdminRoleIdsRef;

    public AdminAdminRoleService(AdminRoleRepository adminRoleRepository, AdminRoleNameRepository adminRoleNameRepository, AdminModelToEntityConverter modelToEntityConverter, AdminEntityToModelConverter entityToModelConverter) {
        super((AdminIdRoleRepository)adminRoleRepository);
        this.adminRoleRepository = adminRoleRepository;
        this.adminRoleNameRepository = adminRoleNameRepository;
        this.modelToEntityConverter = modelToEntityConverter;
        this.entityToModelConverter = entityToModelConverter;
        this.superAdminRoleIdRef = new AtomicReference();
        this.specialAdminRoleIdsRef = new AtomicReference();
    }

    public void saveAdminRole(AddAdminRoleModel model) {
        AdminRole entity = (AdminRole)this.adminRoleRepository.findById(new AdminRoleId(model.getRoleId(), model.getAdminId()));
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(model);
            this.adminRoleRepository.save(entity);
        }
    }

    public void saveAdminRoles(List<AddAdminRoleModel> models) {
        models.forEach(this::saveAdminRole);
    }

    public void deleteAdminRole(long roleId, long adminId) {
        long superAdminCount;
        boolean allow = true;
        long supperAdminRoleId = this.getSuperAdminRoleId();
        if (roleId == supperAdminRoleId && (superAdminCount = this.countActiveSuperAdmins()) <= 1L) {
            allow = false;
        }
        if (allow) {
            this.adminRoleRepository.delete(new AdminRoleId(roleId, adminId));
        }
    }

    public void replaceAdminRoles(long adminId, Collection<Long> roleIds) {
        Set needToAddRoleIds;
        List needToRemoveAdminRoleIds;
        List currentAdminRoles = roleIds.isEmpty() ? Collections.emptyList() : this.adminRoleRepository.findListByField("adminId", adminId);
        List currentAdminRoleIds = EzyLists.newArrayList(currentAdminRoles, AdminRole::identifier);
        Set currentRoleIds = EzySets.newHashSet((Collection)currentAdminRoleIds, AdminRoleId::getRoleId);
        HashSet<Long> inputRoleIds = new HashSet<Long>(roleIds);
        long superAdminCount = this.countActiveSuperAdmins();
        if (superAdminCount <= 1L) {
            inputRoleIds.add(this.getSuperAdminRoleId());
        }
        if (!(needToRemoveAdminRoleIds = currentAdminRoleIds.stream().filter(it -> !inputRoleIds.contains(it.getRoleId())).collect(Collectors.toList())).isEmpty()) {
            this.adminRoleRepository.deleteByIds(needToRemoveAdminRoleIds);
        }
        if (!(needToAddRoleIds = roleIds.stream().filter(it -> !currentRoleIds.contains(it)).collect(Collectors.toSet())).isEmpty()) {
            this.saveAdminRoles(EzyLists.newArrayList(needToAddRoleIds, it -> new AddAdminRoleModel(adminId, (long)it)));
        }
    }

    public AdminRoleNameModel saveAdminRoleNameIfNotExists(AddAdminRoleNameModel model) {
        AdminRoleNameModel existing = this.getAdminRoleNameByNameOrDisplayName(model.getName(), model.getDisplayName());
        if (existing != null) {
            return existing;
        }
        return this.saveAdminRoleName(model);
    }

    public AdminRoleNameModel saveAdminRoleName(AddAdminRoleNameModel model) {
        AdminRoleName entity = this.modelToEntityConverter.toEntity(model);
        this.adminRoleNameRepository.save(entity);
        return this.entityToModelConverter.toModel(entity);
    }

    public void saveAdminRoleName(UpdateAdminRoleNameModel model) {
        AdminRoleName entity = (AdminRoleName)this.adminRoleNameRepository.findById(model.getId());
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.adminRoleNameRepository.save(entity);
    }

    public void deleteAdminRoleNameById(long roleId) {
        this.adminRoleNameRepository.delete(roleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSuperAdminRoleId() {
        if (this.superAdminRoleIdRef.get() == null) {
            AtomicReference<Long> atomicReference = this.superAdminRoleIdRef;
            synchronized (atomicReference) {
                if (this.superAdminRoleIdRef.get() == null) {
                    AdminRoleName superAdminRole = (AdminRoleName)this.adminRoleNameRepository.findByField("name", "super_admin");
                    this.superAdminRoleIdRef.set(superAdminRole.getId());
                }
            }
        }
        return this.superAdminRoleIdRef.get();
    }

    public boolean hasActiveSuperAdmin() {
        long count = this.countActiveSuperAdmins();
        return count > 0L;
    }

    public boolean containsAdminRole(long roleId, long adminId) {
        return this.adminRoleRepository.containsById(new AdminRoleId(roleId, adminId));
    }

    public boolean isAdminHavingSuperRole(long adminId) {
        return this.isAdminHavingRoleName(adminId, "super_admin");
    }

    public boolean isAdminHavingRoleName(long adminId, String roleName) {
        return this.adminRoleRepository.findByAdminIdAndRoleName(adminId, roleName).isPresent();
    }

    public List<AdminRoleNameModel> getAdminRoleNames() {
        return EzyLists.newArrayList((Collection)this.adminRoleNameRepository.findAll(), this.entityToModelConverter::toModel);
    }

    public List<AdminRoleNameModel> getAdminRoleNamesByIds(Collection<Long> roleIds) {
        if (roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList((Collection)this.adminRoleNameRepository.findListByIds(roleIds), this.entityToModelConverter::toModel);
    }

    public List<AdminRoleNameModel> getAdminRoleNamesByAdminId(long adminId) {
        List roleIds = EzyLists.newArrayList((Collection)this.adminRoleRepository.findListByField("adminId", adminId), AdminRole::getRoleId);
        return this.getAdminRoleNamesByIds(roleIds);
    }

    public List<AdminRoleNameModel> getAdminRoleNamesByPriorityGte(int priorityGte) {
        return EzyLists.newArrayList(this.adminRoleNameRepository.findByByPriorityGteOrderByPriorityAndId(priorityGte), this.entityToModelConverter::toModel);
    }

    public List<AdminRoleNameModel> getVisibleAdminRoleNamesByAdminId(long adminId) {
        return this.getAdminRoleNamesByPriorityGte(this.getMinAdminRolePriority(adminId));
    }

    public AdminRoleNameModel getAdminRoleNameById(long id) {
        return this.entityToModelConverter.toModel((AdminRoleName)this.adminRoleNameRepository.findById(id));
    }

    public AdminRoleNameModel getAdminRoleNameByName(String name) {
        return this.entityToModelConverter.toModel((AdminRoleName)this.adminRoleNameRepository.findByField("name", name));
    }

    public AdminRoleNameModel getAdminRoleNameByNameOrDisplayName(String name, String displayName) {
        RxValueMap map = (RxValueMap)Reactive.multiple().register((Object)"name", () -> (AdminRoleName)this.adminRoleNameRepository.findByField("name", name)).register((Object)"displayName", () -> (AdminRoleName)this.adminRoleNameRepository.findByField("displayName", displayName)).blockingGet();
        AdminRoleName entity = (AdminRoleName)map.firstValueOrNull();
        return this.entityToModelConverter.toModel(entity);
    }

    public Set<Long> getRoleIdsByAdminId(long adminId) {
        return EzySets.newHashSet((Collection)this.adminRoleRepository.findListByField("adminId", adminId), AdminRole::getRoleId);
    }

    public List<AdminRoleModel> getAdminRolesByRoleId(long roleId) {
        return EzyLists.newArrayList((Collection)this.adminRoleRepository.findListByField("roleId", roleId), arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0));
    }

    public int getMinAdminRolePriority(long adminId) {
        return this.adminRoleNameRepository.findMinAdminRoleName(adminId).map(AdminRoleName::getPriority).orElse(0);
    }

    public int getMinPriorityByRoleIds(Collection<Long> roleIds) {
        if (roleIds.isEmpty()) {
            throw new IllegalArgumentException("roleIds is required");
        }
        return this.adminRoleNameRepository.findMinRoleByIds(roleIds).map(AdminRoleName::getPriority).orElse(0);
    }

    public List<AdminRoleModel> getAdminRolesByRoleIdAndAdminIds(long roleId, Collection<Long> adminIds) {
        if (adminIds.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList(this.adminRoleRepository.findByRoleIdAndAdminIdIn(roleId, adminIds), arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0));
    }

    public Map<Long, AdminRoleModel> getAdminRoleMapByRoleIdAndAdminIds(long roleId, Collection<Long> adminIds) {
        return EzyMaps.newHashMap(this.getAdminRolesByRoleIdAndAdminIds(roleId, adminIds), AdminRoleModel::getAdminId);
    }

    public boolean containsAdminRoleName(long roleId) {
        return this.adminRoleNameRepository.containsById(roleId);
    }

    public boolean containsAllAdminRoleIds(Collection<Long> roleIds) {
        return this.getAdminRoleNamesByIds(roleIds).size() == roleIds.size();
    }

    public long countAllRoles() {
        return this.adminRoleNameRepository.count();
    }

    public long countActiveSuperAdmins() {
        return this.countActiveAdminsHaveRoleName("super_admin");
    }

    public long countAdminVisibleRoles(long adminId) {
        int minPriority = this.getMinAdminRolePriority(adminId);
        return this.adminRoleNameRepository.countByPriorityGte(minPriority);
    }

    public long countActiveAdminsHaveRoleName(String roleName) {
        AdminRoleName superAdminRole = (AdminRoleName)this.adminRoleNameRepository.findByField("name", roleName);
        return superAdminRole == null ? 0L : (long)this.adminRoleRepository.countActiveAdminByRoleId(superAdminRole.getId());
    }

    public Map<Long, Long> countRoleAdmins(List<Long> roleIds) {
        if (roleIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.adminRoleRepository.findAdminCountsByRoleIds(roleIds).stream().collect(Collectors.toMap(RoleAdminCountResult::getRoleId, RoleAdminCountResult::getAdminCount));
    }

    public Set<Long> getSpecialRoleIds() {
        return this.specialAdminRoleIdsRef.get();
    }

    public void setSpecialRoleIds(Collection<Long> roleIds) {
        this.specialAdminRoleIdsRef.compareAndSet(null, Collections.unmodifiableSet(new HashSet<Long>(roleIds)));
    }
}

