/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpConflictException;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.model.AdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.request.AddAdminRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddAdminRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddAdminRoleRequest;
import org.youngmonkeys.ezyplatform.admin.request.AdminLoginRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveRoleFeaturesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminRolesRequest;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.constant.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

@EzySingleton
public class AdminAdminsValidator {
    private final AdminAdminService adminService;
    private final AdminAdminRoleService adminRoleService;
    private final FeatureURIManager featureUriManager;

    public AdminModel validateAdminId(long adminId) {
        AdminModel admin = this.adminService.getAdminById(adminId);
        if (admin == null) {
            throw new HttpNotFoundException(Collections.singletonMap("admin", "notFound"));
        }
        return admin;
    }

    public AdminModel validateAdminUsername(String username) {
        AdminModel admin = null;
        if (EzyStrings.isNotBlank((String)username)) {
            admin = this.adminService.getAdminByUsername(username);
        }
        if (admin == null) {
            throw new HttpNotFoundException(Collections.singletonMap("admin", "notFound"));
        }
        return admin;
    }

    public void validate(AddAdminRequest request) {
        String displayName;
        String website;
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isEmpty((CharSequence)request.getUsername())) {
            errors.put("username", "required");
        } else if (!DefaultValidator.isValidUsername((String)request.getUsername())) {
            errors.put("username", "invalid");
        } else if (this.adminService.getAdminByUsername(request.getUsername()) != null) {
            errors.put("username", "duplicated");
        }
        if (EzyStrings.isEmpty((CharSequence)request.getEmail())) {
            errors.put("email", "required");
        } else if (!DefaultValidator.isValidEmail((String)request.getEmail())) {
            errors.put("email", "invalid");
        } else if (this.adminService.getAdminByEmail(request.getEmail()) != null) {
            errors.put("email", "duplicated");
        }
        String phone = request.getPhone();
        if (EzyStrings.isNotBlank((String)phone)) {
            if (!DefaultValidator.isValidPhone((String)phone)) {
                errors.put("phone", "invalid");
            } else if (this.adminService.getAdminByPhone(phone) != null) {
                errors.put("phone", "duplicated");
            }
        }
        if (EzyStrings.isNotBlank((String)(website = request.getWebsite())) && !DefaultValidator.isValidHttpUrl((String)website)) {
            errors.put("website", "invalid");
        }
        if (EzyStrings.isNotBlank((String)(displayName = request.getDisplayName())) && DefaultValidator.containsSqlComment((String)displayName)) {
            errors.put("displayName", "invalid");
        }
        if (EzyStrings.isEmpty((CharSequence)request.getPassword())) {
            errors.put("password", "required");
        } else if (request.getPassword().length() < 6) {
            errors.put("password", "tooShort");
        } else if (!DefaultValidator.isValidPassword((String)request.getPassword())) {
            errors.put("password", "invalid");
        }
        if (EzyCollections.isEmpty(request.getRoleIds())) {
            errors.put("roleIds", "required");
        } else if (!this.adminRoleService.containsAllAdminRoleIds(request.getRoleIds())) {
            errors.put("roles", "invalid");
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(AdminLoginRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String username = request.getUsername();
        if (!DefaultValidator.isValidUsername((String)username) && !DefaultValidator.isValidEmail((String)username)) {
            errors.put("username", "invalid");
        }
        if (!DefaultValidator.isValidPassword((String)request.getPassword())) {
            errors.put("password", "invalid");
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long adminId, UpdateAdminRequest request) {
        String displayName;
        String website;
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isEmpty((CharSequence)request.getEmail())) {
            errors.put("email", "required");
        } else if (!DefaultValidator.isValidEmail((String)request.getEmail())) {
            errors.put("email", "invalid");
        }
        String phone = request.getPhone();
        if (EzyStrings.isNotBlank((String)phone)) {
            if (!DefaultValidator.isValidPhone((String)phone)) {
                errors.put("phone", "invalid");
            } else {
                AdminModel admin = this.adminService.getAdminByPhone(phone);
                if (admin != null && admin.getId() != adminId) {
                    errors.put("phone", "duplicated");
                }
            }
        }
        if (EzyStrings.isNotBlank((String)(website = request.getWebsite())) && !DefaultValidator.isValidHttpUrl((String)website)) {
            errors.put("website", "invalid");
        }
        if (EzyStrings.isNotBlank((String)(displayName = request.getDisplayName())) && DefaultValidator.containsSqlComment((String)displayName)) {
            errors.put("displayName", "invalid");
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long adminId, AddAdminRoleNameRequest request) {
        AdminRoleNameModel existing;
        HashMap<String, Object> errors = new HashMap<String, Object>();
        if (EzyStrings.isNoContent((String)request.getName())) {
            errors.put("roleName", "required");
        }
        if (EzyStrings.isNoContent((String)request.getDisplayName())) {
            errors.put("roleDisplayName", "required");
        }
        if ((existing = this.adminRoleService.getAdminRoleNameByNameOrDisplayName(request.getName(), request.getDisplayName())) != null) {
            if (existing.getName().equals(request.getName())) {
                errors.put("roleName", "duplicated");
            }
            if (existing.getDisplayName().equals(request.getDisplayName())) {
                errors.put("roleDisplayName", "duplicated");
            }
        }
        this.validateAdminRolePriority(errors, "rolePriority", adminId, request.getPriority());
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long adminId, long roleId, UpdateAdminRoleNameRequest request) {
        AdminRoleNameModel role = this.validateAdminRoleId(roleId);
        if (AdminRoles.UNMODIFIABLE_ROLE_NAMES.contains(role.getName())) {
            throw new HttpForbiddenException(Collections.singletonMap("editUnmodifiableRoles", "forbidden"));
        }
        HashMap<String, Object> errors = new HashMap<String, Object>();
        if (EzyStrings.isNoContent((String)request.getName())) {
            errors.put("editRoleName", "required");
        }
        if (EzyStrings.isNoContent((String)request.getDisplayName())) {
            errors.put("editRoleDisplayName", "required");
        }
        this.validateAdminRolePriority(errors, "editRolePriority", adminId, request.getPriority());
        AdminRoleNameModel existing = this.adminRoleService.getAdminRoleNameByNameOrDisplayName(request.getName(), request.getDisplayName());
        if (existing != null && existing.getId() != roleId) {
            if (existing.getName().equals(request.getName())) {
                errors.put("editRoleName", "duplicated");
            }
            if (existing.getDisplayName().equals(request.getDisplayName())) {
                errors.put("editRoleDisplayName", "duplicated");
            }
            throw new HttpBadRequestException(errors);
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long byAdminId, AddAdminRoleRequest request) {
        long adminId;
        long roleId = request.getRoleId();
        if (this.adminRoleService.containsAdminRole(roleId, adminId = request.getAdminId())) {
            throw new HttpConflictException(Collections.singletonMap("adminRole", "granted"));
        }
        HashMap<String, Object> errors = new HashMap<String, Object>();
        AdminRoleNameModel role = this.adminRoleService.getAdminRoleNameById(roleId);
        if (!this.adminService.containsAdminById(adminId)) {
            errors.put("adminId", "notFound");
        }
        if (role == null) {
            errors.put("roleId", "notFound");
        } else {
            this.validateAdminRolePriority(errors, "roleId", byAdminId, role.getPriority());
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long adminId, UpdateAdminRolesRequest request) {
        HashMap<String, Object> errors = new HashMap<String, Object>();
        Set<Long> roleIds = request.getRoleIds();
        if (EzyCollections.isEmpty(roleIds)) {
            errors.put("roleIds", "required");
        } else if (roleIds.size() > 500) {
            errors.put("roleIds", "tooMany");
        } else {
            long minAdminPriority;
            long minPriority = this.adminRoleService.getMinPriorityByRoleIds(roleIds);
            if (minPriority < (minAdminPriority = (long)this.adminRoleService.getMinAdminRolePriority(adminId))) {
                errors.put("roleIds", "invalid");
                errors.put("minPriority", minPriority);
                errors.put("minAdminPriority", minAdminPriority);
            }
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long adminId, long roleId, SaveRoleFeaturesRequest request) {
        AdminRoleNameModel role = this.validateAdminRoleId(roleId);
        if (AdminRoles.UNMODIFIABLE_ROLE_NAMES.contains(role.getName())) {
            throw new HttpForbiddenException(Collections.singletonMap("saveUnmodifiableRoles", "forbidden"));
        }
        Map<String, Map<String, List<String>>> methodsUriMapByFeature = request.getMethodsUriMapByFeature();
        HashMap<String, Object> errors = new HashMap<String, Object>();
        if (methodsUriMapByFeature.size() > 3000) {
            errors.put("features", "tooMany");
        }
        this.validateAdminRolePriority(errors, "roleId", adminId, role.getPriority());
        if (errors.isEmpty()) {
            Map urisByFeatureMap = this.featureUriManager.getURIsByFeatureMap();
            block2: for (String feature : methodsUriMapByFeature.keySet()) {
                if (!urisByFeatureMap.containsKey(feature)) {
                    errors.put("features", "invalid");
                    break;
                }
                Map methodsUriMap = urisByFeatureMap.getOrDefault(feature, Collections.emptyMap());
                Map requestMethodsUriMap = methodsUriMapByFeature.getOrDefault(feature, Collections.emptyMap());
                for (String uri : requestMethodsUriMap.keySet()) {
                    if (!methodsUriMap.containsKey(uri)) {
                        errors.put("features", "invalid");
                        break block2;
                    }
                    List methods = methodsUriMap.getOrDefault(uri, Collections.emptyList());
                    List requestMethods = requestMethodsUriMap.getOrDefault(uri, Collections.emptyList());
                    for (String requestMethod : requestMethods) {
                        try {
                            if (methods.contains(HttpMethod.valueOf((String)requestMethod))) continue;
                            errors.put("features", "invalid");
                        }
                        catch (Exception ignored) {
                            errors.put("features", "invalid");
                        }
                        break block2;
                    }
                }
            }
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateDeleteRoleIdAdminId(long byAdminId, long roleId, long adminId, AdminRolesProxy adminRoles) {
        AdminRoleNameModel role = this.validateAdminRoleId(roleId);
        if (!this.adminService.containsAdminById(adminId)) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
        if (role.getName().equals("super_admin") && !adminRoles.isSuperAdmin()) {
            throw new HttpForbiddenException(Collections.singletonMap("permission", "denied"));
        }
        this.validateAdminRolePriority("roleId", byAdminId, role);
    }

    public AdminRoleNameModel validateAdminRoleId(long roleId) {
        AdminRoleNameModel role = this.adminRoleService.getAdminRoleNameById(roleId);
        if (role == null) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
        return role;
    }

    public AdminRoleNameModel validateAdminRoleName(String roleName) {
        AdminRoleNameModel role = this.adminRoleService.getAdminRoleNameByName(roleName);
        if (role == null) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
        return role;
    }

    public AdminRoleNameModel validateDeleteAdminRoleName(long adminId, String roleName) {
        AdminRoleNameModel role;
        if (AdminRoles.UNMODIFIABLE_ROLE_NAMES.contains(roleName)) {
            throw new HttpForbiddenException(Collections.singletonMap("deleteUnmodifiableRoles", "forbidden"));
        }
        HashMap<String, Object> errors = new HashMap<String, Object>();
        if (DefaultValidator.maybeContainsSqlInjection((String)roleName)) {
            errors.put("roleName", "invalid");
        }
        if ((role = this.adminRoleService.getAdminRoleNameByName(roleName)) == null) {
            errors.put("roleName", "notFound");
        } else {
            this.validateAdminRolePriority(errors, "roleName", adminId, role.getPriority());
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
        return role;
    }

    public void validateAdminRoleIds(Collection<Long> roleIds) {
        if (EzyCollections.isEmpty(roleIds)) {
            return;
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Long roleId : roleIds) {
            if (roleId != null && roleId > 0L) continue;
            errors.put("roleIds", "invalid");
            break;
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateAdminRoleNames(Collection<String> roleNames) {
        if (EzyCollections.isEmpty(roleNames)) {
            return;
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        for (String roleName : roleNames) {
            if (!EzyStrings.isBlank((String)roleName) && !DefaultValidator.maybeContainsSqlInjection((String)roleName)) continue;
            errors.put("roleNames", "invalid");
            break;
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public AdminRoleNameModel validateAdminRolePriority(long adminId, String roleName) {
        AdminRoleNameModel role = this.validateAdminRoleName(roleName);
        this.validateAdminRolePriority("roleName", adminId, role);
        return role;
    }

    private void validateAdminRolePriority(String roleNameField, long adminId, AdminRoleNameModel role) {
        HashMap<String, Object> errors = new HashMap<String, Object>();
        this.validateAdminRolePriority(errors, roleNameField, adminId, role.getPriority());
        if (!errors.isEmpty()) {
            throw new HttpForbiddenException(errors);
        }
    }

    private void validateAdminRolePriority(Map<String, Object> errors, String roleFieldName, long adminId, int priority) {
        int minAdminRolePriority = this.adminRoleService.getMinAdminRolePriority(adminId);
        if (priority < minAdminRolePriority) {
            errors.put(roleFieldName, "denied");
            errors.put("minAdminRolePriority", minAdminRolePriority);
        }
    }

    @Generated
    public AdminAdminsValidator(AdminAdminService adminService, AdminAdminRoleService adminRoleService, FeatureURIManager featureUriManager) {
        this.adminService = adminService;
        this.adminRoleService = adminRoleService;
        this.featureUriManager = featureUriManager;
    }
}

