/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.GetRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.core.constant.ContentType;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Part;
import lombok.Generated;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.data.ModuleDependency;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectHasDependingPluginsException;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectInactiveDependenciesException;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectMissingDependenciesException;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectNeedToApplyDependenciesException;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectNeedToUpdateDependenciesException;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMarketUrlManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminProjectInstallationQueue;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.constant.ModuleAction;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.util.Versions;

@EzySingleton
public class AdminProjectsValidator {
    private final TikaConfig tika;
    private final HttpClient httpClient;
    private final AdminMarketUrlManager marketUrlManager;
    private final AdminModuleManager moduleManager;
    private final AdminSettingService settingService;
    private final AdminProjectInstallationQueue projectInstallationQueue;
    private static final String FILE_NAME_PATTERN = "[a-z0-9-]+-+[0-9]+[.][0-9]+[.][0-9]+[.]zip";
    private static final Set<String> CAN_NOT_DELETE_PROJECT_NAMES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"welcome", "socket-monitor"}));
    private static final Set<String> CAN_NOT_DEACTIVATE_PROJECT_NAMES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"socket-monitor"}));

    public void validateProjectAction(ModuleAction action, String projectName, List<ModuleType> moduleTypes) {
        if (!this.moduleManager.containsProject(projectName)) {
            throw new HttpNotFoundException(Collections.singletonMap("project", "notFound"));
        }
        if (action == ModuleAction.DEACTIVATE && CAN_NOT_DEACTIVATE_PROJECT_NAMES.contains(projectName)) {
            throw new HttpForbiddenException(Collections.singletonMap("project", "canNotDeactivate"));
        }
        if (action == ModuleAction.DELETE) {
            if (CAN_NOT_DELETE_PROJECT_NAMES.contains(projectName)) {
                throw new HttpForbiddenException(Collections.singletonMap("project", "canNotDelete"));
            }
            ArrayList<String> activatingModuleTypeNames = new ArrayList<String>();
            for (ModuleType moduleType : moduleTypes) {
                Module module = this.moduleManager.getModule(moduleType, projectName);
                if (module == null || !module.isActive()) continue;
                activatingModuleTypeNames.add(moduleType.getName());
            }
            if (!activatingModuleTypeNames.isEmpty()) {
                throw new HttpForbiddenException(Collections.singletonMap("deleteActivatingModuleTypes", activatingModuleTypeNames));
            }
        }
        if (action == ModuleAction.ACTIVATE) {
            this.validateActivateModule(projectName, moduleTypes);
        } else if (action == ModuleAction.DEACTIVATE) {
            this.validateDeactivateModule(projectName, moduleTypes);
        }
    }

    private void validateActivateModule(String projectName, List<ModuleType> moduleTypes) {
        HashSet<ModuleDependency> missingDependencies = new HashSet<ModuleDependency>();
        HashSet<String> inactivePlugins = new HashSet<String>();
        HashSet<ModuleDependency> needToApplyDependencies = new HashSet<ModuleDependency>();
        HashSet<ModuleDependency> validDependencies = new HashSet<ModuleDependency>();
        for (ModuleType moduleType : moduleTypes) {
            Set<ModuleDependency> dependencies = this.moduleManager.getDependenciesOfModule(moduleType, projectName);
            Iterator<ModuleDependency> iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                ModuleDependency dependency;
                String dependencyProjectName;
                ModuleType actualModuleType = moduleType != ModuleType.THEME ? moduleType : ModuleType.WEB_PLUGIN;
                Module dependencyModule = this.moduleManager.getModule(actualModuleType, dependencyProjectName = (dependency = iterator.next()).getProjectName());
                if (dependencyModule == null) {
                    missingDependencies.add(dependency);
                    continue;
                }
                if (!dependencyModule.isActive()) {
                    inactivePlugins.add(dependencyProjectName);
                    continue;
                }
                Module newModule = this.moduleManager.getNewModule(actualModuleType, dependencyProjectName);
                if (newModule == null) {
                    validDependencies.add(dependency);
                    continue;
                }
                needToApplyDependencies.add(dependency);
            }
        }
        if (!missingDependencies.isEmpty()) {
            throw new ProjectMissingDependenciesException(projectName, missingDependencies);
        }
        if (!inactivePlugins.isEmpty()) {
            throw new ProjectInactiveDependenciesException(projectName, inactivePlugins);
        }
        if (!needToApplyDependencies.isEmpty()) {
            throw new ProjectNeedToApplyDependenciesException(projectName, needToApplyDependencies);
        }
        if (!validDependencies.isEmpty()) {
            List<String> dependencyNames = validDependencies.stream().filter(it -> {
                String dependingVersion = it.getProjectVersion();
                if ("latest".equals(dependingVersion)) {
                    return true;
                }
                String dependencyProjectName = it.getProjectName();
                String newVersion = this.moduleManager.getProjectNewVersion(dependencyProjectName);
                if (EzyStrings.isNotBlank((String)newVersion) && Versions.compareVersions((String)dependingVersion, (String)newVersion) <= 0) {
                    return false;
                }
                String currentVersion = this.moduleManager.getProjectVersion(dependencyProjectName);
                return Versions.compareVersions((String)dependingVersion, (String)currentVersion) > 0;
            }).map(ModuleDependency::getProjectName).collect(Collectors.toList());
            Map<String, String> latestVersionByProjectName = this.getLatestVersionMapByProjectNames(dependencyNames);
            List<ModuleDependency> needToUpdateDependencies = validDependencies.stream().filter(it -> {
                String dependingProjectName = it.getProjectName();
                String latestVersion = (String)latestVersionByProjectName.get(dependingProjectName);
                if (latestVersion == null) {
                    return false;
                }
                String newVersion = this.moduleManager.getProjectNewVersion(dependingProjectName);
                if (EzyStrings.isNotBlank((String)newVersion) && Versions.compareVersions((String)latestVersion, (String)newVersion) <= 0) {
                    return false;
                }
                String currentVersion = this.moduleManager.getProjectVersion(dependingProjectName);
                return Versions.compareVersions((String)latestVersion, (String)currentVersion) > 0;
            }).map(it -> new ModuleDependency(it.getProjectName(), (String)latestVersionByProjectName.get(it.getProjectName()))).collect(Collectors.toList());
            if (!needToUpdateDependencies.isEmpty()) {
                throw new ProjectNeedToUpdateDependenciesException(projectName, needToUpdateDependencies);
            }
        }
    }

    private Map<String, String> getLatestVersionMapByProjectNames(Collection<String> projectNames) {
        if (projectNames.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return (Map)this.httpClient.call((Request)new GetRequest().setURL(this.marketUrlManager.getReleasedProjectsLatestVersionUrl(String.join((CharSequence)",", projectNames))));
        }
        catch (Exception e) {
            throw new IllegalStateException("get latest version of projects failed", e);
        }
    }

    private void validateDeactivateModule(String projectName, List<ModuleType> moduleTypes) {
        HashSet<String> dependingPlugins = new HashSet<String>();
        for (ModuleType moduleType : moduleTypes) {
            dependingPlugins.addAll(this.moduleManager.getDependingModuleNames(moduleType, projectName));
        }
        if (!dependingPlugins.isEmpty()) {
            throw new ProjectHasDependingPluginsException(projectName, dependingPlugins);
        }
    }

    public void validateInstallation(String projectName, String version) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (this.moduleManager.containsProject(projectName, version)) {
            errors.put("status", "installed");
        }
        if (this.projectInstallationQueue.containsProject(projectName)) {
            errors.put("status", "installing");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateUploadFile(Part filePart) throws IOException {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (filePart == null) {
            errors.put("file", "invalid");
        } else {
            String fileName = filePart.getSubmittedFileName();
            if (EzyStrings.isNoContent((String)fileName)) {
                errors.put("fileName", "invalid");
            } else if (!fileName.matches(FILE_NAME_PATTERN)) {
                errors.put("fileName", "invalid");
            }
            if (filePart.getSize() > this.settingService.getMaxProjectBundleFileSize()) {
                errors.put("uploadSize", "over");
            }
            MediaType mediaType = this.tika.getDetector().detect((InputStream)TikaInputStream.get((InputStream)filePart.getInputStream()), new Metadata());
            if (!ContentType.ZIP.getValue().equals(mediaType.toString())) {
                errors.put("fileType", "invalid");
            }
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    @Generated
    public AdminProjectsValidator(TikaConfig tika, HttpClient httpClient, AdminMarketUrlManager marketUrlManager, AdminModuleManager moduleManager, AdminSettingService settingService, AdminProjectInstallationQueue projectInstallationQueue) {
        this.tika = tika;
        this.httpClient = httpClient;
        this.marketUrlManager = marketUrlManager;
        this.moduleManager = moduleManager;
        this.settingService = settingService;
        this.projectInstallationQueue = projectInstallationQueue;
    }
}

